/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.ide.view.mappingsegment;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.editor.controls.EStructuralFeatureSelectionValidator;
import org.eclipse.emf.ecp.view.spi.editor.controls.ReferenceTypeResolver;
import org.eclipse.emf.ecp.view.spi.editor.controls.SegmentIdeDescriptor;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingsegmentPackage;
import org.osgi.service.component.annotations.Component;

@Component(name="MappingSegmentIdeDescriptor")
public class MappingSegmentIdeDescriptor
implements SegmentIdeDescriptor {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String MAP_ENTRY_TYPE_REGEX = "EClassTo.+Map";
    private static final String JAVA_UTIL_MAP_ENTRY = "java.util.Map$Entry";

    public EClass getSegmentType() {
        return VMappingsegmentPackage.Literals.MAPPING_DOMAIN_MODEL_REFERENCE_SEGMENT;
    }

    public boolean isAvailableInIde() {
        return true;
    }

    public boolean isLastElementInPath() {
        return false;
    }

    public boolean isAllowedAsLastElementInPath() {
        return false;
    }

    public EStructuralFeatureSelectionValidator getEStructuralFeatureSelectionValidator() {
        return structuralFeature -> {
            EClass valueEClass;
            EReference ref;
            EClass refType;
            EClass keyEClass;
            if (structuralFeature != null && EReference.class.isInstance(structuralFeature) && structuralFeature.isMany() && (keyEClass = this.getMapKeyType(refType = (ref = (EReference)structuralFeature).getEReferenceType())) != null && EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(keyEClass) && (valueEClass = this.getMapValueType(refType)) != null) {
                return null;
            }
            return "A mapping segment requires a map which has EClass as its key type and an EReference for its values.";
        };
    }

    public ReferenceTypeResolver getReferenceTypeResolver() {
        return (reference, segment) -> {
            if (VMappingDomainModelReferenceSegment.class.isInstance(segment)) {
                VMappingDomainModelReferenceSegment mappingSegment = (VMappingDomainModelReferenceSegment)segment;
                if (mappingSegment.getMappedClass() != null) {
                    return mappingSegment.getMappedClass();
                }
                return this.getMapValueType(reference.getEReferenceType());
            }
            throw new IllegalArgumentException(MessageFormat.format("The given segment '{0}' isn't a mapping segment", segment));
        };
    }

    private EClass getMapValueType(EClass mapType) {
        return this.getMapType(mapType, VALUE);
    }

    private EClass getMapKeyType(EClass mapType) {
        return this.getMapType(mapType, KEY);
    }

    private EClass getMapType(EClass mapType, String featureName) {
        EStructuralFeature feature;
        if (JAVA_UTIL_MAP_ENTRY.equals(mapType.getInstanceClassName()) && mapType.getName().matches(MAP_ENTRY_TYPE_REGEX) && (feature = mapType.getEStructuralFeature(featureName)) != null && EReference.class.isInstance(feature)) {
            return ((EReference)feature).getEReferenceType();
        }
        return null;
    }
}

