/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table.action;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfigurationImpl;
import org.eclipse.emfforms.spi.swt.table.action.ActionControlCreator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.widgets.Control;

public final class ActionConfigurationBuilder {
    private final Map<String, Action> actions = new LinkedHashMap<String, Action>();
    private final Map<String, Collection<KeyStroke>> keyStrokes = new LinkedHashMap<String, Collection<KeyStroke>>();
    private final Map<String, ActionControlCreator<? extends Control>> controlCreatorCallbacks = new LinkedHashMap<String, ActionControlCreator<? extends Control>>();

    private ActionConfigurationBuilder() {
    }

    private ActionConfigurationBuilder(ActionConfiguration configuration) {
        for (Action action : configuration.getActions()) {
            this.addAction(action);
            for (KeyStroke keyStroke : configuration.getKeyStrokesFor(action)) {
                this.addKeyStrokeFor(action.getId(), keyStroke);
            }
            ActionControlCreator<? extends Control> controlCreator = configuration.getControlCreator(action);
            if (controlCreator == null) continue;
            this.addControlFor(action, controlCreator);
        }
    }

    public static ActionConfigurationBuilder usingDefaults() {
        return new ActionConfigurationBuilder();
    }

    public static ActionConfigurationBuilder usingConfiguration(ActionConfiguration configuration) {
        return new ActionConfigurationBuilder(configuration);
    }

    private boolean actionExists(Action action) {
        return this.actions.containsKey(action.getId());
    }

    public ActionConfigurationBuilder addAction(Action action) {
        if (this.actionExists(action)) {
            throw new IllegalArgumentException(MessageFormat.format("Action with id {0} already exists", action.getId()));
        }
        this.actions.put(action.getId(), action);
        return this;
    }

    public ActionConfigurationBuilder addKeySequenceFor(Action action, String ... sequences) {
        this.verifyActionExists(action);
        LinkedHashSet<KeyStroke> strokes = new LinkedHashSet<KeyStroke>();
        try {
            String[] stringArray = sequences;
            int n = sequences.length;
            int n2 = 0;
            while (n2 < n) {
                String sequence = stringArray[n2];
                strokes.add(KeyStroke.getInstance((String)sequence));
                ++n2;
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Invalid key sequence");
        }
        this.addKeyStrokeFor(action.getId(), strokes.toArray(new KeyStroke[0]));
        return this;
    }

    private void addKeyStrokeFor(String actionId, KeyStroke ... strokes) {
        if (this.keyStrokes.get(actionId) == null) {
            this.keyStrokes.put(actionId, new LinkedHashSet());
        }
        this.keyStrokes.get(actionId).addAll(Arrays.asList(strokes));
    }

    private void verifyActionExists(Action action) {
        if (!this.actionExists(action)) {
            throw new IllegalArgumentException(MessageFormat.format("Action with id {0} does not exist. Use addAction() first,", action.getId()));
        }
    }

    public <Creator extends ActionControlCreator<? extends Control>> ActionConfigurationBuilder addControlFor(Action action, Creator controlCreator) {
        this.verifyActionExists(action);
        this.controlCreatorCallbacks.put(action.getId(), controlCreator);
        return this;
    }

    public ActionConfiguration build() {
        return new ActionConfigurationImpl(this.actions, this.keyStrokes, this.controlCreatorCallbacks);
    }
}

