/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.ui.MigrationUIActivator;
import org.eclipse.emf.edapt.migration.ui.MigratorHandlerBase;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadModelHandler
extends MigratorHandlerBase {
    @Override
    protected void run() {
        List<URI> modelURIs = this.getURIs();
        List<URI> metamodelURIs = this.getMetamodelURIs(modelURIs);
        if (metamodelURIs.size() > 0) {
            this.loadEcoreModel(modelURIs, metamodelURIs);
            return;
        }
        super.run();
    }

    private List<URI> getMetamodelURIs(List<URI> modelURIs) {
        ArrayList<URI> metamodelURIs = new ArrayList<URI>();
        Iterator<URI> i = modelURIs.iterator();
        while (i.hasNext()) {
            URI uri = i.next();
            if (!MetamodelUtils.isMetamodelURI((URI)uri)) continue;
            i.remove();
            metamodelURIs.add(uri);
        }
        return metamodelURIs;
    }

    private void loadEcoreModel(List<URI> modelURIs, List<URI> metamodelURIs) {
        try {
            ResourceSet resourceSet = ResourceUtils.loadResourceSet(metamodelURIs, new ArrayList());
            List ePackages = ResourceUtils.getRootElements((ResourceSet)resourceSet, EPackage.class);
            this.loadModel(modelURIs, ePackages);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
    }

    @Override
    protected void run(List<URI> modelURIs, Migrator migrator, Release release) {
        Metamodel metamodel = migrator.getMetamodel(release);
        EList ePackages = metamodel.getEPackages();
        this.loadModel(modelURIs, (List<EPackage>)ePackages);
    }

    /*
     * Unable to fully structure code
     */
    private void loadModel(List<URI> modelURIs, List<EPackage> ePackages) {
        block10: {
            block9: {
                backup = ResourceUtils.register(ePackages, (EPackage.Registry)EPackage.Registry.INSTANCE);
                try {
                    try {
                        page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        editor = (EcoreEditor)page.openEditor((IEditorInput)new URIEditorInput(modelURIs.get(0)), "org.eclipse.emf.ecore.presentation.ReflectiveEditorID");
                        resourceSet = editor.getEditingDomain().getResourceSet();
                        ResourceUtils.resolveAll((ResourceSet)resourceSet);
                        for (URI modelURI : modelURIs) {
                            resourceSet.getResource(modelURI, true);
                            for (EPackage ePackage : ePackages) {
                                resource = ePackage.eResource();
                                if (resourceSet.getResources().contains((Object)resource)) continue;
                                resourceSet.getResources().add((Object)resource);
                            }
                        }
                        break block9;
                    }
                    catch (PartInitException e) {
                        LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
                        ** for (e : backup.entrySet())
                    }
                }
                catch (Throwable var12_19) {
                    ** for (e : backup.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    EPackage.Registry.INSTANCE.put((Object)((String)e.getKey()), e.getValue());
                    continue;
lbl25:
                    // 1 sources

                    break block10;
                }
lbl-1000:
                // 1 sources

                {
                    EPackage.Registry.INSTANCE.put((Object)((String)e.getKey()), e.getValue());
                    continue;
                }
lbl31:
                // 1 sources

                throw var12_19;
            }
            for (Map.Entry<K, V> e : backup.entrySet()) {
                EPackage.Registry.INSTANCE.put((Object)((String)e.getKey()), e.getValue());
            }
        }
    }
}

