/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.HashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="replaceIdentifierByReference", label="Identifier to Reference", description="In the metamodel, an attribute that references elements by identifier is replaced by a reference. In the model, its values are replaced by references to that element.")
public class ReplaceIdentifierByReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The referencing attribute")
    public EAttribute referencingAttribute;
    @EdaptParameter(description="The referenced attribute")
    public EAttribute referencedAttribute;

    @EdaptConstraint(description="Referencing and referenced attribute must be of the same type")
    public boolean checkAttributesSameType() {
        return this.referencedAttribute == null || this.referencingAttribute.getEType() == this.referencedAttribute.getEType();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass referencedClass = this.referencedAttribute.getEContainingClass();
        EClass referencingClass = this.referencingAttribute.getEContainingClass();
        EReference referencingReference = MetamodelFactory.newEReference((EClass)referencingClass, (String)this.referencingAttribute.getName(), (EClass)referencedClass, (int)this.referencingAttribute.getLowerBound(), (int)this.referencingAttribute.getUpperBound());
        metamodel.delete((EModelElement)this.referencingAttribute);
        HashMap<Object, Instance> referencedElements = new HashMap<Object, Instance>();
        for (Instance referencedElement : model.getAllInstances(referencedClass)) {
            referencedElements.put(referencedElement.get((EStructuralFeature)this.referencedAttribute), referencedElement);
        }
        for (Instance referencingElement : model.getAllInstances(referencingClass)) {
            Object reference = referencingElement.unset((EStructuralFeature)this.referencingAttribute);
            referencingElement.set((EStructuralFeature)referencingReference, referencedElements.get(reference));
        }
    }
}

