/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.LastExecution;

import ee.jakarta.tck.concurrent.api.LastExecution.LogicDrivenTrigger;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterCallableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.Trigger;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LastExecutionTests
extends ArquillianTests {
    public static final String IDENTITY_NAME_TEST_ID = "lastExecutionGetIdentityNameTest";

    @Deployment(name="LastExecutionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{LastExecutionTests.getFrameworkPackage(), LastExecutionTests.getCommonFixedCounterPackage(), LastExecutionTests.class.getPackage()});
    }

    @BeforeMethod
    public void reset() {
        StaticCounter.reset();
    }

    @Test
    public void lastExecutionGetIdentityNameTest() {
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        executionProperties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", IDENTITY_NAME_TEST_ID);
        ScheduledFuture sf = TestUtil.getManagedScheduledExecutorService().schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), executionProperties, null), (Trigger)new LogicDrivenTrigger(TestConstants.PollInterval.toMillis(), this.testName));
        TestUtil.waitTillFutureIsDone(sf);
        this.assertEquals("Got wrong identity name. See server log for more details.", 2, StaticCounter.getCount());
    }

    @Test
    public void lastExecutionGetResultRunnableTest() {
        ScheduledFuture sf = TestUtil.getManagedScheduledExecutorService().schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.PollInterval.toMillis(), this.testName));
        TestUtil.waitTillFutureIsDone(sf);
        this.assertEquals("Got wrong last execution result. See server log for more details.", 2, StaticCounter.getCount());
    }

    @Test
    public void lastExecutionGetResultCallableTest() {
        ScheduledFuture sf = TestUtil.getManagedScheduledExecutorService().schedule(ManagedExecutors.managedTask((Callable)new CounterCallableTask(), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.PollInterval.toMillis(), this.testName));
        TestUtil.waitTillFutureIsDone(sf);
        this.assertEquals("Got wrong last execution result. See server log for more details.", 2, StaticCounter.getCount());
    }

    @Test
    public void lastExecutionGetRunningTimeTest() {
        ScheduledFuture sf = TestUtil.getManagedScheduledExecutorService().schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(TestConstants.PollInterval.toMillis()), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.PollInterval.toMillis(), this.testName));
        TestUtil.waitTillFutureIsDone(sf);
        this.assertEquals("Got wrong last execution result.", 2, StaticCounter.getCount());
    }
}

