/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx.Util;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Duration;
import org.testng.Assert;

public class CancelledTransactedTask
implements Runnable {
    private volatile boolean runFlag;
    private volatile boolean transactionBegan;
    private volatile boolean cancelled;
    private final String username;
    private final String password;
    private final String sqlTemplate;

    public CancelledTransactedTask(String username, String password, String sqlTemplate) {
        this.username = username;
        this.password = password;
        this.sqlTemplate = sqlTemplate;
    }

    public void resume() {
        this.runFlag = true;
    }

    public void cancelTask() {
        this.cancelled = true;
    }

    public boolean transactionBegin() {
        return this.transactionBegan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection conn = Util.getConnection(false, this.username, this.password);
        UserTransaction ut = (UserTransaction)TestUtil.lookup("java:comp/UserTransaction");
        Assert.assertNotNull((Object)ut, (String)"didn't get user transaction inside the submitted task.");
        Statement pStmt = null;
        try {
            ut.begin();
            this.transactionBegan = true;
            while (!this.runFlag) {
                TestUtil.sleep(Duration.ofMillis(500L));
            }
            pStmt = conn.prepareStatement(this.sqlTemplate);
            String sTypeDesc = "Type-Cancelled-99";
            int newType = 991;
            pStmt.setInt(1, newType);
            pStmt.setString(2, sTypeDesc);
            pStmt.executeUpdate();
            if (this.cancelled) {
                ut.rollback();
                return;
            }
            ut.commit();
        }
        catch (Exception e) {
            try {
                ut.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                pStmt.close();
                conn.close();
            }
            catch (Exception exception) {}
        }
    }
}

