/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.testng.Assert;

@ContextServiceDefinition.List(value={@ContextServiceDefinition(name="java:app/concurrent/ContextA", propagated={"Application", "IntContext"}, cleared={"StringContext"}, unchanged={"Transaction"}), @ContextServiceDefinition(name="java:module/concurrent/ContextB", cleared={"Transaction"}, unchanged={"Application", "IntContext"}, propagated={"Remaining"}), @ContextServiceDefinition(name="java:comp/concurrent/ContextC")})
@WebServlet(value={"/ContextServiceDefinitionServlet"})
public class ContextServiceDefinitionServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private ExecutorService unmanagedThreads;
    @Resource
    UserTransaction tx;

    public void destroy() {
        this.unmanagedThreads.shutdownNow();
    }

    @Override
    public void before() throws ServletException {
        this.unmanagedThreads = Executors.newFixedThreadPool(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextServiceDefinitionAllAttributes() throws Throwable {
        CompletionStage future;
        ContextService contextServiceA = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextA");
        BiFunction<Object[], String, Object[]> fn = (results, jndiName) -> {
            try {
                results[0] = InitialContext.doLookup(jndiName);
            }
            catch (Throwable x) {
                results[0] = x;
            }
            results[1] = IntContext.get();
            results[2] = StringContext.get();
            try {
                results[3] = this.tx.getStatus();
            }
            catch (SystemException x) {
                throw new CompletionException(x);
            }
            return results;
        };
        try {
            StringContext.set("testContextServiceDefinitionAllAttributes-1");
            IntContext.set(101);
            BiFunction contextualFunction = contextServiceA.contextualFunction(fn);
            future = CompletableFuture.completedFuture(new Object[4]).thenCombineAsync(CompletableFuture.completedFuture("java:app/concurrent/ContextA"), contextualFunction, (Executor)this.unmanagedThreads);
            StringContext.set("testContextServiceDefinitionAllAttributes-2");
            IntContext.set(102);
            this.tx.begin();
            Object[] results2 = (Object[])contextualFunction.apply(new Object[4], "java:app/concurrent/ContextA");
            if (results2[0] instanceof Throwable) {
                throw ((Throwable)((Object)new AssertionError((Object)"Application context must be propagated to inline contextual BiFunction to perform lookup of java:app/concurrent/ContextA"))).initCause((Throwable)results2[0]);
            }
            Assert.assertTrue((boolean)(results2[0] instanceof ContextService), (String)"Application context must be propagated to inline contextual BiFunction per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals((Object)results2[1], (Object)101, (String)"Third-party context type IntContext must be propagated to inline contextual BiFunction per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals((Object)results2[2], (Object)"", (String)"Third-party context type StringContext must be cleared from inline contextual BiFunction per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals((Object)results2[3], (Object)0, (String)"Transaction context must be left unchanged on inline contextual BiFunction per java:app/concurrent/ContextA configuration.");
            Assert.assertNotNull(InitialContext.doLookup("java:app/concurrent/ContextA"), (String)"Previous Application context must be present after inline contextual BiFunction.");
            Assert.assertEquals((int)IntContext.get(), (int)102, (String)"Third-party context type IntContext must be restored after inline contextual BiFunction.");
            Assert.assertEquals((String)StringContext.get(), (String)"testContextServiceDefinitionAllAttributes-2", (String)"Third-party context type StringContext must be restored after inline contextual BiFunction.");
            Assert.assertEquals((int)this.tx.getStatus(), (int)0, (String)"Transaction context must remain on thread after inline contextual BiFunction because it is to be left unchanged per java:app/concurrent/ContextA configuration.");
        }
        finally {
            StringContext.set("");
            IntContext.set(0);
            if (this.tx.getStatus() != 6) {
                this.tx.rollback();
            }
        }
        Object[] results3 = (Object[])((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        if (results3[0] instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError((Object)"Application context must be propagated to async contextual BiFunction to perform lookup of java:app/concurrent/ContextA"))).initCause((Throwable)results3[0]);
        }
        Assert.assertTrue((boolean)(results3[0] instanceof ContextService), (String)"Application context must be propagated to async contextual BiFunction per java:app/concurrent/ContextA configuration.");
        Assert.assertEquals((Object)results3[1], (Object)101, (String)"Third-party context type IntContext must be propagated to async contextual BiFunction per java:app/concurrent/ContextA configuration.");
        Assert.assertEquals((Object)results3[2], (Object)"", (String)"Third-party context type StringContext must be cleared from async contextual BiFunction per java:app/concurrent/ContextA configuration.");
        Assert.assertEquals((Object)results3[3], (Object)6, (String)"Transaction context must be left unchanged on async contextual BiFunction per java:app/concurrent/ContextA configuration.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextServiceDefinitionDefaults() throws Throwable {
        ContextService contextService = (ContextService)InitialContext.doLookup("java:comp/concurrent/ContextC");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        try {
            IntContext.set(13);
            new Thread(contextService.contextualRunnable(() -> {
                results.add(IntContext.get());
                try {
                    results.add(InitialContext.doLookup("java:comp/concurrent/ContextC"));
                }
                catch (Throwable x) {
                    results.add(x);
                }
            })).start();
        }
        finally {
            IntContext.set(0);
        }
        this.tx.begin();
        try {
            StringContext.set("testContextServiceDefinitionDefaults-1");
            Callable callable = contextService.contextualCallable(() -> {
                UserTransaction tran = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                tran.begin();
                tran.commit();
                return StringContext.get();
            });
            StringContext.set("testContextServiceDefinitionDefaults-2");
            Assert.assertEquals((String)((String)callable.call()), (String)"testContextServiceDefinitionDefaults-1", (String)"Third-party context type StringContext must be propagated to contextual Callable.");
            Assert.assertEquals((int)this.tx.getStatus(), (int)0, (String)"Transaction must be restored on thread after contextual proxy completes.");
        }
        finally {
            StringContext.set(null);
            this.tx.rollback();
        }
        Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertNotNull(result, (String)"Contextual runnable did not start on thread.");
        Assert.assertEquals(result, (Object)13, (String)"Third-party context type IntContext must be propagated to contextual Runnable.");
        result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertNotNull(result, (String)"Contextual runnable did not complete on thread.");
        if (result instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError((Object)"Unable to look up java:comp name from contextual Runnable."))).initCause((Throwable)result);
        }
        Assert.assertTrue((boolean)(result instanceof ContextService), (String)("Application context must be propagated to contextual Runnable, but instead lookup found: " + result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextServiceDefinitionWithThirdPartyContext() throws Throwable {
        try {
            StringContext.set("testCSDWithThirdPartyContext-1");
            IntContext.set(31);
            ContextService contextServiceA = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextA");
            BiConsumer consumerA = contextServiceA.contextualConsumer((intQ, strQ) -> {
                intQ.add(IntContext.get());
                strQ.add(StringContext.get());
            });
            LinkedBlockingQueue queueA = new LinkedBlockingQueue();
            CompletableFuture qFutureA = CompletableFuture.completedFuture(queueA);
            qFutureA.thenAcceptBothAsync((CompletionStage)qFutureA, consumerA, (Executor)this.unmanagedThreads);
            ContextService contextServiceB = (ContextService)InitialContext.doLookup("java:module/concurrent/ContextB");
            BiConsumer consumerB = contextServiceB.contextualConsumer((intQ, strQ) -> {
                intQ.add(IntContext.get());
                strQ.add(StringContext.get());
            });
            LinkedBlockingQueue queueB = new LinkedBlockingQueue();
            CompletableFuture qFutureB = CompletableFuture.completedFuture(queueB);
            qFutureB.thenAcceptBothAsync((CompletionStage)qFutureB, consumerB);
            StringContext.set("testCSDWithThirdPartyContext-2");
            IntContext.set(32);
            LinkedList results = new LinkedList();
            consumerA.accept(results, results);
            Assert.assertEquals(results.poll(), (Object)31, (String)"Third-party context type IntContext must be propagated to inline contextual BiConsumer per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals(results.poll(), (Object)"", (String)"Third-party context type StringContext must be cleared from inline contextual BiConsumer per java:app/concurrent/ContextA configuration.");
            consumerB.accept(results, results);
            Assert.assertEquals(results.poll(), (Object)32, (String)"Third-party context type IntContext must be left unchanged on inline contextual BiConsumer per java:module/concurrent/ContextB configuration.");
            Assert.assertEquals(results.poll(), (Object)"testCSDWithThirdPartyContext-1", (String)"Third-party context type StringContext must be propagated to inline contextual BiConsumer per java:module/concurrent/ContextB configuration.");
            Assert.assertEquals(queueA.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)31, (String)"Third-party context type IntContext must be propagated to async contextual BiConsumer per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals(queueA.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"", (String)"Third-party context type StringContext must be cleared from async contextual BiConsumer per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals(queueB.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)0, (String)"Third-party context type IntContext must be left unchanged on async contextual BiConsumer per java:module/concurrent/ContextB configuration.");
            Assert.assertEquals(queueB.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"testCSDWithThirdPartyContext-1", (String)"Third-party context type StringContext must be propagated to async contextual BiConsumer per java:module/concurrent/ContextB configuration.");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextualConsumer() throws Throwable {
        ContextService contextService = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextA");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        try {
            StringContext.set("testContextualConsumer-1");
            IntContext.set(121);
            Consumer contextualConsumer = contextService.contextualConsumer(queue -> {
                queue.add(IntContext.get());
                queue.add(StringContext.get());
                try {
                    queue.add(InitialContext.doLookup("java:app/concurrent/ContextA"));
                }
                catch (Throwable x) {
                    queue.add(x);
                }
            });
            CompletableFuture.completedFuture(results).thenAcceptAsync(contextualConsumer, (Executor)this.unmanagedThreads);
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
        }
        Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertNotNull(result, (String)"Contextual Consumer did not start running.");
        Assert.assertEquals(result, (Object)121, (String)"Third-party context type IntContext must be propagated to contextual Consumer per java:app/concurrent/ContextA configuration.");
        result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertNotNull(result, (String)"Contextual Consumer did not continue running.");
        Assert.assertEquals(result, (Object)"", (String)"Third-party context type StringContext must be cleared on contextual Consumer per java:app/concurrent/ContextA configuration.");
        result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertNotNull(result, (String)"Contextual Consumer did not complete.");
        if (result instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError((Object)"Application context must be propagated to contextual Consumer"))).initCause((Throwable)result);
        }
        Assert.assertTrue((boolean)(result instanceof ContextService), (String)"Application context must be propagated to contextual Consumer per java:app/concurrent/ContextA configuration.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextualFunction() throws Throwable {
        CompletionStage future;
        ContextService contextService = (ContextService)InitialContext.doLookup("java:module/concurrent/ContextB");
        this.tx.begin();
        try {
            StringContext.set("testContextualFunction-1");
            IntContext.set(151);
            Function contextualFunction = contextService.contextualFunction(jndiName -> {
                Object[] results = new Object[4];
                try {
                    results[0] = InitialContext.doLookup(jndiName);
                }
                catch (NamingException x) {
                    results[0] = x;
                }
                results[1] = IntContext.get();
                results[2] = StringContext.get();
                try {
                    results[3] = this.tx.getStatus();
                }
                catch (SystemException x) {
                    throw new CompletionException(x);
                }
                return results;
            });
            future = CompletableFuture.completedFuture("java:module/concurrent/ContextB").thenApplyAsync(contextualFunction);
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
            this.tx.rollback();
        }
        Object[] results = (Object[])((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)(results[0] instanceof NamingException), (String)("Application context must remain unchanged on contextual Function per java:module/concurrent/ContextB configuration. Result: " + results[0]));
        Assert.assertEquals((Object)results[1], (Object)0, (String)"Third-party context type IntContext must remain unchanged on contextual Function per java:module/concurrent/ContextB configuration.");
        Assert.assertEquals((Object)results[2], (Object)"testContextualFunction-1", (String)"Third-party context type StringContext must be propagated to contextual Function per java:module/concurrent/ContextB configuration.");
        Assert.assertEquals((Object)results[3], (Object)6, (String)"Transaction context must be cleared from contextual Function per java:module/concurrent/ContextB configuration.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextualSupplier() throws Throwable {
        try {
            StringContext.set("testContextualSupplier-1");
            IntContext.set(61);
            ContextService contextServiceA = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextA");
            Supplier supplierA = contextServiceA.contextualSupplier(() -> new AbstractMap.SimpleEntry<Integer, String>(IntContext.get(), StringContext.get()));
            CompletableFuture futureA = CompletableFuture.supplyAsync(supplierA, this.unmanagedThreads);
            StringContext.set("testContextualSupplier-2");
            IntContext.set(62);
            Map.Entry results = (Map.Entry)futureA.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertEquals(results.getKey(), (Object)61, (String)"Third-party context type IntContext must be propagated to async contextual Supplier per java:app/concurrent/ContextA configuration.");
            Assert.assertEquals((String)((String)results.getValue()), (String)"", (String)"Third-party context type StringContext must be cleared from async contextual Supplier per java:app/concurrent/ContextA configuration.");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyWithContextCapture() throws Throwable {
        ContextService contextService = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextA");
        try {
            StringContext.set("testCopyWithContextCapture-1");
            IntContext.set(171);
            CompletableFuture stage1unmanaged = new CompletableFuture();
            CompletableFuture stage1copy = contextService.withContextCapture(stage1unmanaged);
            IntContext.set(172);
            CompletionStage stage2 = stage1copy.exceptionally(failure -> {
                Assert.assertEquals((int)IntContext.get(), (int)172, (String)"Third-party context type IntContext must be propagated to the .exceptionally Function per java:app/concurrent/ContextA configuration.");
                return "java:app/concurrent/ContextA";
            });
            IntContext.set(173);
            CompletionStage stage3 = ((CompletableFuture)stage2).thenAcceptAsync(jndiName -> {
                Assert.assertEquals((String)StringContext.get(), (String)"", (String)"Third-party context type StringContext must be cleared from async contextual Consumer per java:app/concurrent/ContextA configuration.");
                try {
                    Assert.assertNotNull(InitialContext.doLookup("java:app/concurrent/ContextA"), (String)"Application context must be propagated to async contextual Consumer per java:app/concurrent/ContextA configuration.");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            stage1unmanaged.completeExceptionally(new UnsupportedOperationException("Intentionally raised to force the .exceptionally code path"));
            Assert.assertEquals(((CompletableFuture)stage3).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), null, (String)"Dependent stages should complete in response to the completion of the stage from which the first stage was copied.");
            Assert.assertTrue((boolean)stage1copy.isCompletedExceptionally(), (String)"Copied stage must complete the same way as the stage from which it is copied.");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
        }
    }
}

