/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.anno;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.common.qualifiers.CustomQualifier1;
import ee.jakarta.tck.concurrent.common.qualifiers.CustomQualifier2;
import ee.jakarta.tck.concurrent.common.qualifiers.InvalidQualifier3;
import ee.jakarta.tck.concurrent.common.qualifiers.OverwrittenQualifier4;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationTestBeanInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

@ContextServiceDefinition(name="java:app/concurrent/ContextE", qualifiers={CustomQualifier1.class}, cleared={"IntContext"}, propagated={"Application", "StringContext"}, unchanged={"Transaction"})
@ManagedExecutorDefinition(name="java:app/concurrent/ExecutorE", context="java:app/concurrent/ContextE", qualifiers={CustomQualifier2.class}, maxAsync=3)
@ManagedScheduledExecutorDefinition(name="java:app/concurrent/ScheduledExecutorE", context="java:app/concurrent/ContextE", qualifiers={CustomQualifier1.class, CustomQualifier2.class}, maxAsync=2, hungTaskThreshold=200000L)
@ManagedThreadFactoryDefinition(name="java:app/concurrent/ThreadFactoryE", context="java:app/concurrent/ContextE", qualifiers={OverwrittenQualifier4.class}, priority=6)
@WebServlet(value={"/AnnotationServlet"})
@Dependent
public class AnnotationServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    @EJB
    private AnnotationTestBeanInterface enterpriseBean;
    @Resource
    private UserTransaction tx;
    @Inject
    private ContextService injectedDefContextSvc;
    @Inject
    @CustomQualifier1
    private ContextService injectedContextE;
    @Inject
    private ManagedExecutorService injectedDefMES;
    @Inject
    @CustomQualifier2
    private ManagedExecutorService injectedMESE;
    @Inject
    private ManagedScheduledExecutorService injectedDefMSES;
    @Inject
    @CustomQualifier1
    @CustomQualifier2
    private ManagedScheduledExecutorService injectedMSESE;
    @Inject
    private ManagedThreadFactory injectedDefMTF;
    @Resource(lookup="java:app/concurrent/ThreadFactoryE")
    private ManagedThreadFactory resourceMTFE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeCallableWithContext(ContextService svc, int value) throws Exception {
        try {
            IntContext.set(value);
            Callable result = svc.contextualCallable(() -> IntContext.get());
            Integer n = (Integer)result.call();
            return n;
        }
        finally {
            IntContext.set(0);
        }
    }

    public void testAnnoDefinedContextServiceQualifiers() throws Throwable {
        Assertions.assertAll((String)"Context Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefContextSvc, (String)"Default contextService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedContextE, (String)"Annotation defined contextService was not registered with required qualifier."), () -> Assertions.assertTrue((boolean)CDI.current().select(ContextService.class, new Annotation[]{InvalidQualifier3.Literal.get()}).isUnsatisfied(), (String)"A contextService was satisfied with a qualifier which was not defined in it's annotation")});
        ContextService lookupDefContextSvc = (ContextService)InitialContext.doLookup("java:comp/DefaultContextService");
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(this.injectedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default Context Service behavior differed between injection and lookup");
        ContextService lookupContextE = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextE");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextE, 65), (String)"Annotation defined Context Service that was looked up did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(this.injectedContextE, 85), (String)"Annotation defined Context Service that was injected based on a qualifier did not clear the IntContext as configured.");
    }

    public void testAnnoDefinedManagedExecutorSvcQualifiers() throws Throwable {
        Assertions.assertAll((String)"Managed Executor Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMES, (String)"Default managedExecutorService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedMESE, (String)"Annotation defined managedExecutorService was not registered with required qualifiers."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedExecutorService.class, new Annotation[]{CustomQualifier2.Literal.get(), InvalidQualifier3.Literal.get()}).isUnsatisfied(), (String)"A managedExecutorService was satisfied with both a required and non-required qualifier.")});
        ManagedExecutorService lookupDefMES = (ManagedExecutorService)InitialContext.doLookup("java:comp/DefaultManagedExecutorService");
        ContextService lookupDefContextSvc = lookupDefMES.getContextService();
        ContextService extractedDefContextSvc = this.injectedDefMES.getContextService();
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(extractedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default ManagedExecutorService behavior via context service differed between injection and lookup");
        ManagedExecutorService lookupMESE = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorE");
        ContextService lookupContextE = lookupMESE.getContextService();
        ContextService extractedContextE = this.injectedMESE.getContextService();
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextE, 65), (String)"Annotation defined and looked up ManagedExecutorService was configured with a context service that did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(extractedContextE, 85), (String)"Annotation defined and injected ManagedExecutorService was configured with a context service that did not clear the IntContext as configured.");
    }

    public void testAnnoDefinedManagedScheduledExecutorSvcQualifers() throws Throwable {
        Assertions.assertAll((String)"Managed Scheduled Executor Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMSES, (String)"Default managedScheduledExecutorService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedMSESE, (String)"Annotation defined managedScheduledExecutorService was not registered with required qualifiers."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedScheduledExecutorService.class, new Annotation[]{CustomQualifier1.Literal.get()}).isResolvable(), (String)"A managedScheduledExecutorService was not satisfied with one of two configured qualifiers.")});
        ManagedScheduledExecutorService lookupDefMSES = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/DefaultManagedScheduledExecutorService");
        ContextService lookupDefContextSvc = lookupDefMSES.getContextService();
        ContextService extractedDefContextSvc = this.injectedDefMSES.getContextService();
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(extractedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default ManagedScheduledExecutorService behavior via context service differed between injection and lookup");
        ManagedScheduledExecutorService lookupMSESE = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorE");
        ContextService lookupContextE = lookupMSESE.getContextService();
        ContextService extractedContextE = this.injectedMSESE.getContextService();
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextE, 65), (String)"Annotation defined and looked up ManagedScheduledExecutorService was configured with a context service that did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(extractedContextE, 85), (String)"Annotation defined and injected ManagedScheduledExecutorService was configured with a context service that did not clear the IntContext as configured.");
    }

    public void testAnnoDefinedManagedThreadFactoryQualifersFull() throws Throwable {
        ManagedThreadFactory lookupDefMTF = (ManagedThreadFactory)InitialContext.doLookup("java:comp/DefaultManagedThreadFactory");
        ManagedThreadFactory lookupMTFE = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryE");
        Assertions.assertAll((String)"Thread Factory Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMTF, (String)"Default managedThreadFactory was not registered with default qualifier."), () -> Assertions.assertEquals((int)lookupDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (int)this.injectedDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (String)"Default managedThreadFactory from injection and lookup did not have the same priority."), () -> Assertions.assertNotNull((Object)this.resourceMTFE, (String)"Annotation defined managedThreadFactory with qualifiers could not be found via @Resource."), () -> Assertions.assertEquals((int)lookupMTFE.newThread(NOOP_RUNNABLE).getPriority(), (int)this.resourceMTFE.newThread(NOOP_RUNNABLE).getPriority(), (String)"The managedThreadFactory from resource injection and lookup did not have the same priority."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedThreadFactory.class, new Annotation[]{OverwrittenQualifier4.Literal.get()}).isResolvable(), (String)"A managedThreadFactory was not satisfied with a required qualifier that was not overwritten by a deployment descriptor.")});
    }

    public void testAnnoDefinedManagedThreadFactoryQualifersWeb() throws Throwable {
        ManagedThreadFactory lookupDefMTF = (ManagedThreadFactory)InitialContext.doLookup("java:comp/DefaultManagedThreadFactory");
        ManagedThreadFactory lookupMTFE = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryE");
        Assertions.assertAll((String)"Thread Factory Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMTF, (String)"Default managedThreadFactory was not registered with default qualifier."), () -> Assertions.assertEquals((int)lookupDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (int)this.injectedDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (String)"Default managedThreadFactory from injection and lookup did not have the same priority."), () -> Assertions.assertNotNull((Object)this.resourceMTFE, (String)"Annotation defined managedThreadFactory with no qualifiers could not be found via @Resource."), () -> Assertions.assertEquals((int)lookupMTFE.newThread(NOOP_RUNNABLE).getPriority(), (int)this.resourceMTFE.newThread(NOOP_RUNNABLE).getPriority(), (String)"The managedThreadFactory from resource injection and lookup did not have the same priority."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedThreadFactory.class, new Annotation[]{OverwrittenQualifier4.Literal.get()}).isUnsatisfied(), (String)"A managedThreadFactory was satisfied with a required qualifier that should have been overwritten by the deployment descriptor.")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationDefinesContextService() throws Throwable {
        int status;
        Callable checkContextAndGetTransactionStatus;
        ContextService contextSvc = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextE");
        this.tx.begin();
        try {
            IntContext.set(1001);
            StringContext.set("testAnnotationDefinesContextService-1");
            checkContextAndGetTransactionStatus = contextSvc.contextualCallable(() -> {
                Assertions.assertEquals((int)0, (int)IntContext.get());
                Assertions.assertEquals((Object)"testAnnotationDefinesContextService-1", (Object)StringContext.get());
                Assertions.assertNotNull(InitialContext.doLookup("java:app/concurrent/ExecutorE"));
                return this.tx.getStatus();
            });
            StringContext.set("testAnnotationDefinesContextService-2");
            status = (Integer)checkContextAndGetTransactionStatus.call();
            Assertions.assertEquals((int)0, (int)status);
            Assertions.assertEquals((int)1001, (int)IntContext.get());
            Assertions.assertEquals((Object)"testAnnotationDefinesContextService-2", (Object)StringContext.get());
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
            this.tx.rollback();
        }
        status = (Integer)checkContextAndGetTransactionStatus.call();
        Assertions.assertEquals((int)6, (int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationDefinesManagedExecutor() throws Throwable {
        LinkedBlockingQueue started = new LinkedBlockingQueue();
        CountDownLatch taskCanEnd = new CountDownLatch(1);
        Supplier<String> task = () -> {
            try {
                started.add(InitialContext.doLookup("java:app/concurrent/ExecutorE"));
                Assertions.assertTrue((boolean)taskCanEnd.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
            return StringContext.get();
        };
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorE");
        try {
            StringContext.set("testAnnotationDefinesManagedExecutor-1");
            CompletableFuture future1 = executor.supplyAsync(task);
            StringContext.set("testAnnotationDefinesManagedExecutor-2");
            CompletableFuture future2 = executor.supplyAsync(task);
            StringContext.set("testAnnotationDefinesManagedExecutor-3");
            CompletableFuture future3 = executor.supplyAsync(task);
            StringContext.set("testAnnotationDefinesManagedExecutor-4");
            CompletableFuture future4 = executor.supplyAsync(task);
            StringContext.set("testAnnotationDefinesManagedExecutor-5");
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals(null, started.poll(1L, TimeUnit.SECONDS));
            taskCanEnd.countDown();
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedExecutor-1", future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedExecutor-2", future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedExecutor-3", future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedExecutor-4", future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    public void testAnnotationDefinesManagedScheduledExecutor() throws Throwable {
        this.enterpriseBean.testAnnotationDefinesManagedScheduledExecutor();
    }

    public void testAnnotationDefinesManagedThreadFactory() throws Throwable {
        this.enterpriseBean.testAnnotationDefinesManagedThreadFactory();
    }
}

