/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedScheduledExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import com.sun.enterprise.deployment.annotation.handlers.ManagedScheduledExecutorDefinitionData;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ManagedScheduledExecutorDefinitionConverter
extends ConcurrencyDefinitionConvertor<ManagedScheduledExecutorDefinitionData, ManagedScheduledExecutorDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ManagedScheduledExecutorDefinitionConverter.class.getName());

    ManagedScheduledExecutorDefinitionConverter() {
        super(ManagedScheduledExecutorDefinitionDescriptor.class, JavaEEResourceType.MSEDD);
    }

    @Override
    ManagedScheduledExecutorDefinitionDescriptor createDescriptor(ManagedScheduledExecutorDefinitionData data) {
        return new ManagedScheduledExecutorDefinitionDescriptor(data, MetadataSource.ANNOTATION);
    }

    @Override
    ManagedScheduledExecutorDefinitionData getData(ManagedScheduledExecutorDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ManagedScheduledExecutorDefinitionData> convert(ManagedScheduledExecutorDefinition[] annotation) {
        LOG.log(System.Logger.Level.TRACE, "convert(annotation={0})", new Object[]{annotation});
        if (annotation == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(annotation).map(this::convert).collect(Collectors.toSet());
    }

    ManagedScheduledExecutorDefinitionData convert(ManagedScheduledExecutorDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(annotation={0})", annotation);
        ManagedScheduledExecutorDefinitionData data = new ManagedScheduledExecutorDefinitionData();
        data.setName(TranslatedConfigView.expandValue((String)annotation.name()));
        data.setContext(TranslatedConfigView.expandValue((String)annotation.context()));
        if (annotation.hungTaskThreshold() < 0L) {
            data.setHungTaskThreshold(0L);
        } else {
            data.setHungTaskThreshold(annotation.hungTaskThreshold());
        }
        if (annotation.maxAsync() < 0) {
            data.setMaxAsync(Integer.MAX_VALUE);
        } else {
            data.setMaxAsync(annotation.maxAsync());
        }
        return data;
    }

    @Override
    void merge(ManagedScheduledExecutorDefinitionData annotationData, ManagedScheduledExecutorDefinitionData descriptorData) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotationData={0}, descriptorData={1})", annotationData, descriptorData);
        if (!annotationData.getName().equals(descriptorData.getName())) {
            throw new IllegalArgumentException("Cannot merge managed executors with different names: " + annotationData.getName() + " x " + descriptorData.getName());
        }
        if (descriptorData.getHungTaskThreshold() <= 0L && annotationData.getHungTaskThreshold() != 0L) {
            descriptorData.setHungTaskThreshold(annotationData.getHungTaskThreshold());
        }
        if (descriptorData.getMaxAsync() <= 0) {
            descriptorData.setMaxAsync(annotationData.getMaxAsync());
        }
        if (descriptorData.getContext() == null && annotationData.getContext() != null && !annotationData.getContext().isBlank()) {
            descriptorData.setContext(TranslatedConfigView.expandValue((String)annotationData.getContext()));
        }
    }
}

