/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.element.Element;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

public class IdRangeValidator {
    private final Map<String, Map<ValidIdRange, MessageInterface>> processed = new HashMap<String, Map<ValidIdRange, MessageInterface>>();

    public Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (ValidIdRange validIdRange : messageInterface.validIdRanges()) {
            if (validIdRange.min() > validIdRange.max()) {
                messages.add(ValidationMessageFactory.createError((Element)messageInterface, "Minimum id value (%d) cannot be greater than the maximum value (%d).", validIdRange.min(), validIdRange.max()));
                continue;
            }
            Map<ValidIdRange, MessageInterface> processed = this.getProcessed(messageInterface);
            for (Map.Entry<ValidIdRange, MessageInterface> entry : processed.entrySet()) {
                ValidIdRange vid = entry.getKey();
                if (!this.overlap(validIdRange, vid)) continue;
                messages.add(ValidationMessageFactory.createError((Element)messageInterface, "@ValidIdRange min/max (%d/%d) overlap the range (%d/%d) on '%s'.", validIdRange.min(), validIdRange.max(), vid.min(), vid.max(), entry.getValue().name()));
            }
            MessageInterface previous = processed.put(validIdRange, messageInterface);
            if (previous == null) continue;
            messages.add(ValidationMessageFactory.createError((Element)messageInterface, "%s was used on %s", validIdRange, messageInterface.name()));
        }
        return messages;
    }

    private boolean overlap(ValidIdRange r1, ValidIdRange r2) {
        return r1.min() >= r2.min() && r1.min() <= r2.max() || r1.max() >= r2.min() && r1.max() <= r2.max() || r2.min() >= r1.min() && r2.min() <= r1.max() || r2.max() >= r1.min() && r2.max() <= r1.max();
    }

    private Map<ValidIdRange, MessageInterface> findAll(MessageInterface messageInterface) {
        HashMap<ValidIdRange, MessageInterface> result = new HashMap<ValidIdRange, MessageInterface>();
        for (ValidIdRange validIdRange : messageInterface.validIdRanges()) {
            result.put(validIdRange, messageInterface);
        }
        for (MessageInterface sub : messageInterface.extendedInterfaces()) {
            result.putAll(this.findAll(sub));
        }
        return result;
    }

    private Map<ValidIdRange, MessageInterface> getProcessed(MessageInterface messageInterface) {
        String projectCode = messageInterface.projectCode();
        if (projectCode.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.processed.containsKey(projectCode)) {
            return this.processed.get(projectCode);
        }
        HashMap<ValidIdRange, MessageInterface> result = new HashMap<ValidIdRange, MessageInterface>();
        this.processed.put(projectCode, result);
        return result;
    }
}

