/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;

public class CookiePersistentManager
extends StandardManager {
    private static final String LAST_ACCESSED_TIME = "lastAccessedTime=";
    private static final String MAX_INACTIVE_INTERVAL = "maxInactiveInterval=";
    private static final String IS_VALID = "isValid=";
    private final Set<String> sessionIds = new HashSet<String>();
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private String cookieName;

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        Set<String> set = this.sessionIds;
        synchronized (set) {
            if (!this.sessionIds.add(session.getIdInternal())) {
                throw new IllegalArgumentException("Session with id " + session.getIdInternal() + " already present");
            }
            int size = this.sessionIds.size();
            if (size > this.maxActive) {
                this.maxActive = size;
            }
        }
    }

    @Override
    public Session findSession(String id, HttpServletRequest request) throws IOException {
        if (this.cookieName == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Object value = null;
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return this.parseSession(cookie.getValue(), request.getRequestedSessionId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSessions() {
        Set<String> set = this.sessionIds;
        synchronized (set) {
            this.sessionIds.clear();
        }
    }

    @Override
    public Session[] findSessions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session) {
        Set<String> set = this.sessionIds;
        synchronized (set) {
            this.sessionIds.remove(session.getIdInternal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cookie toCookie(Session session) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(IS_VALID + session.isValid() + ";");
        sb.append(LAST_ACCESSED_TIME + session.getLastAccessedTime() + ";");
        sb.append(MAX_INACTIVE_INTERVAL + session.getMaxInactiveInterval() + ";");
        Map<String, Object> map = session.getAttributes();
        synchronized (map) {
            Set<Map.Entry<String, Object>> entries = session.getAttributes().entrySet();
            int numElements = entries.size();
            int i = 0;
            for (Map.Entry<String, Object> entry : entries) {
                sb.append(entry.getKey() + "=" + entry.getValue());
                if (i++ >= numElements - 1) continue;
                sb.append(',');
            }
        }
        this.remove(session);
        return new Cookie(this.cookieName, sb.toString());
    }

    @Override
    public void checkSessionAttribute(String name, Object value) {
        if (!(value instanceof String)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00337"), name);
            throw new IllegalArgumentException(msg);
        }
    }

    private Session parseSession(String value, String sessionId) throws IOException {
        String[] entries;
        String[] components = value.split(";");
        if (components.length != 4) {
            throw new IllegalArgumentException("Invalid session encoding");
        }
        StandardSession session = (StandardSession)this.createSession(sessionId);
        int index = components[0].indexOf(61);
        if (index < 0) {
            throw new IllegalArgumentException("Missing separator for isValid");
        }
        session.setValid(Boolean.parseBoolean(components[0].substring(index + 1, components[0].length())));
        index = components[1].indexOf(61);
        if (index < 0) {
            throw new IllegalArgumentException("Missing separator for lastAccessedTime");
        }
        session.setLastAccessedTime(Long.parseLong(components[1].substring(index + 1, components[1].length())));
        index = components[2].indexOf(61);
        if (index < 0) {
            throw new IllegalArgumentException("Missing separator for maxInactiveInterval");
        }
        session.setMaxInactiveInterval(Integer.parseInt(components[2].substring(index + 1, components[2].length())));
        for (String entry : entries = components[3].split(",")) {
            index = entry.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Missing session attribute key-value separator");
            }
            session.setAttribute(entry.substring(0, index), entry.substring(index + 1, entry.length()));
        }
        return session;
    }
}

