/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ActiveOutboundResourceAdapter;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.util.RARUtils;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.DelegatingClassLoader;

public class ConnectorConfigParserUtils {
    private static final Logger LOG = LogDomains.getLogger(ConnectorConfigParserUtils.class, (String)"jakarta.enterprise.resource.resourceadapter");

    public Properties mergeProps(Set<ConnectorConfigProperty> ddVals, Properties introspectedVals) {
        Properties mergedVals = new Properties(introspectedVals);
        if (ddVals != null) {
            ConnectorConfigProperty[] ddProps;
            for (ConnectorConfigProperty ddProp : ddProps = (ConnectorConfigProperty[])ddVals.toArray(ConnectorConfigProperty[]::new)) {
                mergedVals.setProperty(ddProp.getName(), ddProp.getValue());
            }
        }
        return mergedVals;
    }

    public Properties mergePropsReturnTypes(Set<ConnectorConfigProperty> ddVals, Properties introspectedVals) {
        Properties mergedVals = new Properties(introspectedVals);
        if (ddVals != null) {
            ConnectorConfigProperty[] ddProps;
            for (ConnectorConfigProperty ddProp : ddProps = (ConnectorConfigProperty[])ddVals.toArray(ConnectorConfigProperty[]::new)) {
                mergedVals.setProperty(ddProp.getName(), ddProp.getType());
            }
        }
        return mergedVals;
    }

    public Properties introspectJavaBean(String className, Set ddPropsSet) throws ConnectorRuntimeException {
        return this.introspectJavaBean(className, ddPropsSet, false, null);
    }

    public Properties introspectJavaBean(String className, Set<ConnectorConfigProperty> ddPropsSet, boolean associateResourceAdapter, String resourceAdapterName) throws ConnectorRuntimeException {
        Object loadedInstance;
        block6: {
            Class<?> loadedClass = this.loadClass(className, resourceAdapterName);
            loadedInstance = this.instantiate(loadedClass);
            try {
                if (associateResourceAdapter) {
                    ActiveResourceAdapter activeRA = ConnectorRegistry.getInstance().getActiveResourceAdapter(resourceAdapterName);
                    if (activeRA == null) {
                        ConnectorRuntime.getRuntime().loadDeferredResourceAdapter(resourceAdapterName);
                        activeRA = ConnectorRegistry.getInstance().getActiveResourceAdapter(resourceAdapterName);
                    }
                    if (activeRA instanceof ActiveOutboundResourceAdapter) {
                        ResourceAdapter raInstance = activeRA.getResourceAdapter();
                        if (loadedInstance instanceof ResourceAdapterAssociation) {
                            ((ResourceAdapterAssociation)loadedInstance).setResourceAdapter(raInstance);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "rardeployment.error_associating_ra", e);
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.log(Level.FINE, "Exception while associating the resource adapter to the JavaBean", e);
            }
        }
        return this.introspectJavaBean(loadedInstance, ddPropsSet);
    }

    public Properties introspectJavaBean(Object javaBeanInstance, Set<ConnectorConfigProperty> ddPropsSet) throws ConnectorRuntimeException {
        Class<?> loadedClass = javaBeanInstance.getClass();
        Method[] methods = loadedClass.getMethods();
        Properties props = new Properties();
        String name = null;
        String value = null;
        ConnectorConfigProperty[] ddProps = ddPropsSet == null ? null : (ConnectorConfigProperty[])ddPropsSet.toArray(ConnectorConfigProperty[]::new);
        for (Method method : methods) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Method -> " + method.getName() + ":" + method.getReturnType());
            }
            if (!this.isProperty(method) || this.presentInDDProps(method, ddProps) || !this.isValid(method, loadedClass)) continue;
            name = this.getPropName(method);
            value = this.getPropValue(method, loadedClass, javaBeanInstance);
            props.setProperty(name, value);
        }
        return props;
    }

    public Properties introspectJavaBeanReturnTypes(String className, Set<ConnectorConfigProperty> ddPropsSet, String rarName) throws ConnectorRuntimeException {
        Class<?> loadedClass = this.loadClass(className, rarName);
        Method[] methods = loadedClass.getMethods();
        Properties props = new Properties();
        String name = null;
        String value = null;
        ConnectorConfigProperty[] ddProps = ddPropsSet == null ? null : (ConnectorConfigProperty[])ddPropsSet.toArray(ConnectorConfigProperty[]::new);
        for (Method method : methods) {
            if (!this.isProperty(method) || this.presentInDDProps(method, ddProps)) continue;
            name = this.getPropName(method);
            value = this.getPropType(method);
            if (value == null) continue;
            props.setProperty(name, value);
        }
        return props;
    }

    private boolean presentInDDProps(Method method, ConnectorConfigProperty[] ddProps) {
        String name = null;
        String ddPropName = null;
        int length = "set".length();
        if (method != null) {
            name = method.getName().substring(length);
        }
        for (int i = 0; name != null && ddProps != null && i < ddProps.length; ++i) {
            ddPropName = ddProps[i].getName();
            if (!name.equalsIgnoreCase(ddPropName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(Method setMethod, Class<?> loadedClass) {
        Method getMethod = this.correspondingGetMethod(setMethod, loadedClass);
        if (getMethod == null) {
            return false;
        }
        return RARUtils.isValidRABeanConfigProperty(getMethod.getReturnType());
    }

    private boolean isProperty(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        return methodName.startsWith("set") && parameterTypes.length == 1;
    }

    private String getPropName(Method method) {
        if (method == null) {
            return null;
        }
        String methodName = method.getName();
        int length = "set".length();
        String retValue = methodName.substring(length, length + 1).toUpperCase(Locale.getDefault()) + methodName.substring(length + 1);
        return retValue;
    }

    private Method correspondingGetMethod(Method setMethod, Class<?> loadedClass) {
        Method[] allMethods = loadedClass.getMethods();
        int length = "set".length();
        String methodName = setMethod.getName();
        Class<?>[] parameterTypes = null;
        String[] possibleGetMethodNames = new String[]{"is" + methodName.substring(length), "get" + methodName.substring(length)};
        for (Method method : allMethods) {
            if (!method.getName().equals(possibleGetMethodNames[0]) && !method.getName().equals(possibleGetMethodNames[1]) || (parameterTypes = method.getParameterTypes()).length != 0) continue;
            return method;
        }
        return null;
    }

    private String getPropValue(Method method, Class<?> loadedClass, Object loadedInstance) {
        Object retValue;
        block5: {
            retValue = null;
            Method getMethod = this.correspondingGetMethod(method, loadedClass);
            if (getMethod != null) {
                try {
                    retValue = getMethod.invoke(loadedInstance, (Object[])null);
                }
                catch (IllegalAccessException ie) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "rardeployment.illegalaccess_error", loadedClass.getName());
                    }
                }
                catch (InvocationTargetException ie) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.log(Level.FINE, "Failed to invoke the method", loadedClass.getName());
                }
            }
        }
        return this.convertToString(retValue);
    }

    private String getPropType(Method method) {
        Class<?>[] parameterTypeClass = method.getParameterTypes();
        if (parameterTypeClass.length != 1) {
            return null;
        }
        if (parameterTypeClass[0].isPrimitive() || parameterTypeClass[0].getName().equals("java.lang.String")) {
            return parameterTypeClass[0].getName();
        }
        return null;
    }

    private String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Integer || obj instanceof Float || obj instanceof Long || obj instanceof Double || obj instanceof Character || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short) {
            return String.valueOf(obj);
        }
        return "";
    }

    private Class<?> loadClass(String className, String resourceAdapterName) throws ConnectorRuntimeException {
        Class<?> loadedClass = null;
        try {
            if (ConnectorsUtil.belongsToSystemRA((String)resourceAdapterName)) {
                DelegatingClassLoader classLoader = ConnectorRuntime.getRuntime().getConnectorClassLoader();
                loadedClass = classLoader.loadClass(className);
            } else {
                ConnectorApplication app = ConnectorRegistry.getInstance().getConnectorApplication(resourceAdapterName);
                if (app == null) {
                    LOG.log(Level.FINE, "unable to load class [ " + className + " ] of RAR [ " + resourceAdapterName + " ] from server instance, trying other instances' deployments");
                    loadedClass = RARUtils.loadClassFromRar(resourceAdapterName, className);
                } else {
                    loadedClass = app.getClassLoader().loadClass(className);
                }
            }
        }
        catch (ClassNotFoundException e1) {
            LOG.log(Level.FINE, "rardeployment.class_not_found", className);
            throw new ConnectorRuntimeException("Class Not Found : " + className);
        }
        return loadedClass;
    }

    private Object instantiate(Class<?> loadedClass) throws ConnectorRuntimeException {
        try {
            return loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException ie) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "rardeployment.illegalaccess_error", loadedClass.getName());
            }
            throw new ConnectorRuntimeException("Couldnot access class : " + loadedClass.getName());
        }
        catch (ReflectiveOperationException ie) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "rardeployment.class_instantiation_error", loadedClass.getName());
            }
            throw new ConnectorRuntimeException("Could not instantiate class : " + loadedClass.getName());
        }
    }
}

