/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.commandlogger;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.messaging.MessageReceiver;
import org.glassfish.hk2.api.messaging.SubscribeTo;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.events.CommandInvokedEvent;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10, mode=0)
@MessageReceiver(value={CommandInvokedEvent.class})
public class AdminCommandLogger {
    private static final System.Logger logger = System.getLogger(AdminCommandLogger.class.getName());

    public void receiveCommandInvokedEvent(@SubscribeTo CommandInvokedEvent event) {
        this.logCommand(event.getCommandName(), event.getParameters(), event.getUserPrincipal().map(Principal::getName).orElse("Unknown user"));
    }

    public void logCommand(String commandName, ParameterMap parameters, String userName) {
        if (this.shouldLogCommand(commandName)) {
            String commandLine = this.constructCommandLine(commandName, parameters);
            logger.log(System.Logger.Level.INFO, () -> "User " + userName + " executed admin command: " + commandLine);
        }
    }

    private String constructCommandLine(String commandName, ParameterMap parameters) {
        String DEFAULT_PARAM_KEY = "DEFAULT";
        Stream<String> namedParamsStream = parameters.entrySet().stream().filter(param -> !"userpassword".equals(param.getKey())).filter(param -> !"DEFAULT".equals(param.getKey())).map(param -> "--" + (String)param.getKey() + "=" + (String)((List)param.getValue()).get(0));
        List unnamedParams = parameters.get((Object)"DEFAULT");
        Stream<Object> unnamedParamsStream = unnamedParams != null ? unnamedParams.stream() : Stream.empty();
        return Stream.concat(Stream.concat(Stream.of(commandName), namedParamsStream), unnamedParamsStream).collect(Collectors.joining(" "));
    }

    private boolean shouldLogCommand(String commandName) {
        LogMode logMode = LogMode.get();
        switch (logMode) {
            case ALL_COMMANDS: {
                return true;
            }
            case NO_COMMAND: {
                return false;
            }
            case INTERNAL_COMMANDS: {
                return !this.isReadCommand(commandName);
            }
            case READ_WRITE_COMMANDS: {
                return !this.isInternalCommand(commandName);
            }
            case WRITE_COMMANDS: {
                return !this.isReadCommand(commandName) && !this.isInternalCommand(commandName);
            }
        }
        throw new IllegalStateException("Log mode " + logMode + " not supported yet.");
    }

    private boolean isReadCommand(String commandName) {
        return Stream.of("attach", "backup-domain", "collect-log-files", "export(.*)", "generate-jvm-report", "get(.*)", "jms-ping", "list(.*)", "login", "monitor", "ping(.*)", "show(.*)", "uptime", "validate(.*)", "verify(.*)", "version", "(.*)-list-services").filter(commandName::matches).findAny().isPresent();
    }

    private boolean isInternalCommand(String commandName) {
        return commandName.matches("_(.*)");
    }

    public static enum LogMode {
        ALL_COMMANDS,
        INTERNAL_COMMANDS,
        WRITE_COMMANDS,
        READ_WRITE_COMMANDS,
        NO_COMMAND;

        public static final LogMode DEFAULT;
        public static final String PROPERTY_NAME = "glassfish.commandlogger.logmode";

        public static LogMode get() {
            String logModeValue = TranslatedConfigView.expandValue((String)"${glassfish.commandlogger.logmode}");
            if (logModeValue != null && !logModeValue.startsWith("$")) {
                try {
                    return LogMode.valueOf(logModeValue);
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.WARNING, () -> "The value of the property glassfish.commandlogger.logmode is invalid: " + logModeValue + ". It should be one of " + Arrays.toString((Object[])LogMode.values()));
                    return DEFAULT;
                }
            }
            return DEFAULT;
        }

        static {
            DEFAULT = NO_COMMAND;
        }
    }
}

