/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ValidationInformation;
import org.glassfish.hk2.api.Validator;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.common.SecureServiceAccessPermission;
import org.glassfish.security.services.common.SecurityAccessValidationService;

public class SecurityAccessValidator
implements Validator {
    private static final Logger LOG = SecurityAccessValidationService._theLog;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityAccessValidator.class);

    public boolean validate(ValidationInformation info) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ValidationInformation info= " + String.valueOf(info));
        }
        switch (info.getOperation()) {
            case BIND: 
            case UNBIND: {
                return this.validateBindAndUnbind(info);
            }
            case LOOKUP: {
                return this.validateLookup(info.getCandidate(), info.getInjectee());
            }
        }
        return false;
    }

    private boolean isSecureAnnotated(ValidationInformation info) {
        ActiveDescriptor d = info.getCandidate();
        Set qualifiers = d.getQualifiers();
        if (qualifiers != null && qualifiers.size() != 0) {
            for (String s : qualifiers) {
                if (!Secure.class.getCanonicalName().equals(s)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("The instance is annotated with 'Secure': " + String.valueOf(info));
                }
                return true;
            }
        }
        return false;
    }

    private boolean validateBindAndUnbind(ValidationInformation info) {
        if (!this.isSecureAnnotated(info)) {
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("validateBindAndUnbind, injectee= " + String.valueOf(info.getInjectee()));
        }
        return this.validateLookup(info.getCandidate(), info.getInjectee());
    }

    private boolean validateLookup(ActiveDescriptor<?> candidate, Injectee injectee) {
        Set contracts;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Lookup candiate =" + String.valueOf(candidate) + ", injectee= " + String.valueOf(injectee));
        }
        if (!candidate.isReified()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lookup candiate is not reified yet");
            }
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Lookup candiate is reified, candidate = " + String.valueOf(candidate));
        }
        if ((contracts = candidate.getAdvertisedContracts()) == null) {
            return true;
        }
        Map md = candidate.getMetadata();
        if (LOG.isLoggable(Level.FINE)) {
            for (Map.Entry entry : md.entrySet()) {
                String k = (String)entry.getKey();
                for (String v : (List)entry.getValue()) {
                    LOG.fine("$$ key= " + k + ", value= " + v);
                }
            }
        }
        Permission perm = null;
        List names = (List)md.get("accessPermissionName");
        if (names == null || names.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Perm name is empty, will use default value");
            }
            perm = this.getAccessPermision("security/service/default", null);
        } else {
            String permName = (String)names.get(0);
            perm = this.getAccessPermision(permName, null);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("The permission to be protected = " + String.valueOf(perm));
        }
        boolean check_result = false;
        if (injectee == null) {
            Class caller = this.getServiceLookupCaller();
            check_result = this.checkPerm(perm, caller);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lookup, checked perm for = " + String.valueOf(perm) + ", result= " + check_result);
            }
        } else {
            check_result = this.validateInjection(candidate, injectee, perm);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Injection, checked perm for = " + String.valueOf(perm) + ", result= " + check_result);
            }
        }
        return check_result;
    }

    private Class getServiceLookupCaller() {
        return null;
    }

    private boolean checkPerm(Permission p, Class caller) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Checked perm for = " + String.valueOf(p));
        }
        try {
            if (caller != null) {
                ProtectionDomain pd = this.getCallerProtDomain(caller);
                pd.implies(p);
            } else {
                AccessController.checkPermission(p);
            }
        }
        catch (SecurityException e) {
            LOG.warning(localStrings.getLocalString("sec.validate.lookup.deny", "Check Permission failed in lookup for permission = {0}", new Object[]{p}));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Check Permission failed, perm= " + String.valueOf(p) + ", message = " + e.getMessage());
            }
            throw e;
        }
        return true;
    }

    private boolean validateInjection(ActiveDescriptor<?> candidate, Injectee injectee, Permission p) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Injectee =" + String.valueOf(injectee) + ", permission= " + String.valueOf(p));
        }
        Class injecteeClass = injectee.getInjecteeClass();
        ProtectionDomain pd = this.getCallerProtDomain(injecteeClass);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Protection domain code src= " + String.valueOf(pd.getCodeSource()));
        }
        if (!pd.implies(p)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("permission check failed for " + String.valueOf(injectee) + ", to get perm " + String.valueOf(p) + ", for candidate " + String.valueOf(candidate));
            }
            throw new AccessControlException(localStrings.getLocalString("sec.validate.injection.deny", "Access denied for injectee {0} to get permission {1}.", new Object[]{injectee, p}));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("permission check success for " + String.valueOf(injectee) + " to get " + String.valueOf(candidate));
        }
        return true;
    }

    private ProtectionDomain getCallerProtDomain(final Class caller) {
        ProtectionDomain pd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return caller.getProtectionDomain();
            }
        });
        return pd;
    }

    private Permission getAccessPermision(String protectName, String action) {
        return new SecureServiceAccessPermission(protectName, action);
    }
}

