/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardLocation;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

@SupportedOptions(value={"org.jboss.logging.tools.report.type", "org.jboss.logging.tools.report.path", "org.jboss.logging.tools.report.title"})
public class ReportFileGenerator
extends AbstractGenerator {
    static final String REPORT_TYPE = "org.jboss.logging.tools.report.type";
    static final String REPORT_PATH = "org.jboss.logging.tools.report.path";
    static final String REPORT_TITLE = "org.jboss.logging.tools.report.title";
    private final ReportType reportType;
    private final String reportPath;
    private final String reportTitle;

    ReportFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        String reportType = options.get(REPORT_TYPE);
        this.reportPath = options.get(REPORT_PATH);
        this.reportTitle = options.get(REPORT_TITLE);
        if (reportType == null) {
            this.reportType = null;
        } else {
            String s = reportType.toLowerCase(Locale.ROOT);
            if ("adoc".equals(s) || "asciidoc".equals(s)) {
                this.reportType = ReportType.ASCIIDOC;
            } else if ("xml".equals(s)) {
                this.reportType = ReportType.XML;
            } else {
                this.reportType = null;
                this.logger().warn(null, "Report type %s is invalid. No reports will be generated.", reportType);
            }
        }
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.reportType != null) {
            try {
                if (messageInterface.methods().isEmpty()) {
                    this.logger().debug(element, "Skipping reports for interface %s with no methods.", messageInterface.name());
                    return;
                }
                this.logger().debug(element, "Writing reports for interface %s.", messageInterface.name());
                String fileName = messageInterface.simpleName() + this.reportType.getExtension();
                try (BufferedWriter writer = this.createWriter(messageInterface.packageName(), fileName, this.processingEnv.getElementUtils().getTypeElement(messageInterface.name()));
                     ReportWriter reportWriter = ReportWriter.of(this.reportType, messageInterface, writer);){
                    reportWriter.writeHeader(this.reportTitle);
                    for (MessageMethod messageMethod : ReportFileGenerator.getSortedMessageMethods(messageInterface)) {
                        reportWriter.writeDetail(messageMethod);
                    }
                    reportWriter.writeFooter();
                }
            }
            catch (IOException e) {
                this.logger().error((Element)element, e, "Failed to generate %s report", new Object[]{this.reportType});
            }
        }
    }

    private BufferedWriter createWriter(String packageName, String fileName, Element originatingElement) throws IOException {
        if (this.reportPath == null) {
            return new BufferedWriter(this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName, originatingElement).openWriter());
        }
        Path outputPath = Paths.get(this.reportPath, packageName.replace(".", FileSystems.getDefault().getSeparator()), fileName);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        return Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
    }

    private static Collection<MessageMethod> getSortedMessageMethods(MessageInterface messageInterface) {
        TreeSet<MessageMethod> messageMethods = new TreeSet<MessageMethod>(MessageMethodSortComparator.INSTANCE);
        messageMethods.addAll(messageInterface.methods());
        return messageMethods;
    }

    private static class MessageMethodSortComparator
    implements Comparator<MessageMethod> {
        static final MessageMethodSortComparator INSTANCE = new MessageMethodSortComparator();

        private MessageMethodSortComparator() {
        }

        @Override
        public int compare(MessageMethod o1, MessageMethod o2) {
            int result = Integer.compare(o1.message().id(), o2.message().id());
            if (result == 0) {
                result = o1.message().value().compareTo(o2.message().value());
            }
            return result;
        }
    }
}

