/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.ibm.jbatch.spi.TaggedJobExecution;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommand;
import org.glassfish.batch.AbstractLongListCommand;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_ListBatchJobs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="_ListBatchJobs")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_ListBatchJobs", description="_List Batch Jobs")})
public class ListBatchJobs
extends AbstractLongListCommand {
    private static final String JOB_NAME = "jobName";
    private static final String APP_NAME = "appName";
    private static final String INSTANCE_COUNT = "instanceCount";
    private static final String INSTANCE_ID = "instanceId";
    private static final String EXECUTION_ID = "executionId";
    private static final String BATCH_STATUS = "batchStatus";
    private static final String EXIT_STATUS = "exitStatus";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    @Param(primary=true, optional=true)
    String jobName;

    @Override
    protected void executeCommand(AdminCommandContext context, Properties extraProps) throws Exception {
        ColumnFormatter columnFormatter = new ColumnFormatter(this.getDisplayHeaders());
        if (this.isSimpleMode()) {
            extraProps.put("simpleMode", (Object)true);
            extraProps.put("listBatchJobs", this.findSimpleJobInfo(columnFormatter));
        } else {
            extraProps.put("simpleMode", (Object)false);
            ArrayList<Map<String, Object>> jobExecutions = new ArrayList<Map<String, Object>>();
            extraProps.put("listBatchJobs", jobExecutions);
            for (JobExecution je : this.findJobExecutions()) {
                try {
                    if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)je).getTagName())) continue;
                    jobExecutions.add(this.handleJob(je, columnFormatter));
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + String.valueOf(ex));
                    this.logger.log(Level.FINE, "Exception while getting jobExecution details ", ex);
                }
            }
        }
        context.getActionReport().setMessage(columnFormatter.toString());
    }

    @Override
    protected final String[] getAllHeaders() {
        return new String[]{JOB_NAME, APP_NAME, INSTANCE_COUNT, INSTANCE_ID, EXECUTION_ID, BATCH_STATUS, START_TIME, END_TIME, EXIT_STATUS};
    }

    @Override
    protected final String[] getDefaultHeaders() {
        return new String[]{JOB_NAME, INSTANCE_COUNT};
    }

    private boolean isSimpleMode() {
        for (String h : this.getOutputHeaders()) {
            if (JOB_NAME.equals(h) || INSTANCE_COUNT.equals(h)) continue;
            return false;
        }
        return this.getOutputHeaders().length == 2;
    }

    private Map<String, Integer> findSimpleJobInfo(ColumnFormatter columnFormatter) throws JobSecurityException, NoSuchJobException {
        HashMap<String, Integer> jobToInstanceCountMap = new HashMap<String, Integer>();
        List<JobExecution> jobExecutions = this.findJobExecutions();
        for (JobExecution jobExecution : jobExecutions) {
            if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)jobExecution).getTagName())) continue;
            String jobName = jobExecution.getJobName();
            int count = 0;
            if (jobToInstanceCountMap.containsKey(jobName)) {
                count = (Integer)jobToInstanceCountMap.get(jobName);
            }
            jobToInstanceCountMap.put(jobName, count + 1);
        }
        for (Map.Entry entry : jobToInstanceCountMap.entrySet()) {
            columnFormatter.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        return jobToInstanceCountMap;
    }

    private List<JobExecution> findJobExecutions() throws JobSecurityException, NoSuchJobException, NoSuchJobInstanceException {
        ArrayList<JobExecution> jobExecutions;
        block5: {
            JobOperator jobOperator;
            block4: {
                jobExecutions = new ArrayList<JobExecution>();
                jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
                if (this.jobName == null) break block4;
                List<JobInstance> exe = jobOperator.getJobInstances(this.jobName, 0, 0x7FFFFFFE);
                if (exe == null) break block5;
                for (JobInstance ji : exe) {
                    jobExecutions.addAll(jobOperator.getJobExecutions(ji));
                }
                break block5;
            }
            Set<String> jobNames = jobOperator.getJobNames();
            if (jobNames != null) {
                for (String jn : jobOperator.getJobNames()) {
                    List<JobInstance> exe = jobOperator.getJobInstances(jn, 0, 0x7FFFFFFE);
                    if (exe == null) continue;
                    for (JobInstance ji : exe) {
                        jobExecutions.addAll(jobOperator.getJobExecutions(ji));
                    }
                }
            }
        }
        return jobExecutions;
    }

    private Map<String, Object> handleJob(JobExecution je, ColumnFormatter columnFormatter) throws JobSecurityException, NoSuchJobException, NoSuchJobExecutionException {
        HashMap<String, Object> jobInfo = new HashMap<String, Object>();
        Object[] cfData = new String[this.getOutputHeaders().length];
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        for (int index = 0; index < this.getOutputHeaders().length; ++index) {
            Object data = null;
            switch (this.getOutputHeaders()[index]) {
                case "jobName": {
                    data = je.getJobName();
                    break;
                }
                case "appName": {
                    try {
                        String appName = ((TaggedJobExecution)je).getTagName();
                        int semi = appName.indexOf(58);
                        data = appName.substring(semi + 1);
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.FINE, "Error while calling ((TaggedJobExecution) je).getTagName() ", ex);
                        data = ex.toString();
                    }
                    break;
                }
                case "instanceCount": {
                    data = jobOperator.getJobInstanceCount(je.getJobName());
                    break;
                }
                case "instanceId": {
                    data = jobOperator.getJobInstance(je.getExecutionId()).getInstanceId();
                    break;
                }
                case "executionId": {
                    data = je.getExecutionId();
                    break;
                }
                case "batchStatus": {
                    data = je.getBatchStatus() != null ? je.getBatchStatus() : "";
                    break;
                }
                case "exitStatus": {
                    data = je.getExitStatus() != null ? je.getExitStatus() : "";
                    break;
                }
                case "startTime": {
                    if (je.getStartTime() != null) {
                        data = je.getStartTime().getTime();
                        cfData[index] = je.getStartTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "endTime": {
                    if (je.getEndTime() != null) {
                        data = je.getEndTime().getTime();
                        cfData[index] = je.getEndTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header: " + this.getOutputHeaders()[index]);
                }
            }
            jobInfo.put(this.getOutputHeaders()[index], data);
            if (cfData[index] != null) continue;
            cfData[index] = data.toString();
        }
        columnFormatter.addRow(cfData);
        return jobInfo;
    }
}

