/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

import java.net.URL;
import org.jboss.weld.bootstrap.spi.Metadata;

public class FileMetadata<T>
implements Metadata<T> {
    private final T value;
    private final URL file;
    private final int lineNumber;

    public FileMetadata(T value, URL file, int lineNumber) {
        this.value = value;
        this.file = file;
        this.lineNumber = lineNumber;
    }

    @Override
    public String getLocation() {
        if (this.value != null) {
            return this.file.toString() + "@" + this.lineNumber + "[" + String.valueOf(this.value) + "]";
        }
        return this.file.toString() + "@" + this.lineNumber;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public URL getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return this.getLocation();
    }
}

