/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.jaas.PermissionFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.Subject;

public class JAASAccessControlModel
implements AccessControlModel {
    public static final String TYPE = "jaas";
    public static final String PROP_PERMISSION_FACTORY = "jaas.permissionFactory";
    private Logger logger = Globals.getLogger();
    private PermissionFactory permFactory = null;

    @Override
    public void initialize(String type, Properties authProperties) {
        if (!type.equals(TYPE)) {
            Object[] args = new String[]{type, TYPE, this.getClass().getName()};
            String emsg = Globals.getBrokerResources().getKString("B4072", args);
            this.logger.log(32, emsg);
            throw new AccessControlException(emsg);
        }
        Properties authProps = authProperties;
        String pfclass = authProps.getProperty("imq.accesscontrol.jaas.permissionFactory");
        try {
            if (pfclass != null) {
                this.permFactory = (PermissionFactory)Class.forName(pfclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), (Throwable)e);
            throw new AccessControlException(e.getClass().getName() + ": " + e.getMessage());
        }
        this.load();
    }

    @Override
    public void load() {
        try {
            Policy.getPolicy().refresh();
        }
        catch (SecurityException e) {
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
    }

    @Override
    public void checkConnectionPermission(Principal clientUser, String serviceName, String serviceType, Subject subject) {
        Permission perm;
        try {
            perm = this.permFactory.newPermission("mq-conn::" + serviceType, null);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.toString(), (Throwable)e);
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
        try {
            this.checkPermission(subject, perm);
        }
        catch (AccessControlException e) {
            AccessControlException ace = new AccessControlException(e.getMessage() + ": " + String.valueOf(clientUser) + " [" + String.valueOf(subject.getPrincipals()) + "]");
            ace.initCause(e);
            throw ace;
        }
    }

    @Override
    public void checkDestinationPermission(Principal clientUser, String serviceName, String serviceType, Subject subject, String operation, String destination, String destinationType) {
        Permission perm;
        try {
            perm = operation.equals("create") ? this.permFactory.newPermission("mq-auto::queue", null) : this.permFactory.newPermission("mq-dest::queue:" + destination, operation);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.toString(), (Throwable)e);
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
        try {
            this.checkPermission(subject, perm);
        }
        catch (AccessControlException e) {
            AccessControlException ace = new AccessControlException(e.getMessage() + ": " + String.valueOf(clientUser) + " [" + String.valueOf(subject.getPrincipals()) + "]");
            ace.initCause(e);
            throw ace;
        }
    }

    private void checkPermission(Subject subject, Permission p) {
        final Permission perm = p;
        Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                AccessController.checkPermission(perm);
                return null;
            }
        }, null);
    }
}

