/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.xml.ws.transport.tcp.server.TCPContext;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class TCPStandaloneContext
implements TCPContext {
    private final ClassLoader classloader;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public TCPStandaloneContext(ClassLoader classloader) {
        this.classloader = classloader;
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        return this.classloader.getResourceAsStream(resource);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        try {
            return this.populateResourcePaths(path);
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    @Override
    public URL getResource(String resource) {
        if (resource.charAt(0) == '/') {
            resource = resource.substring(1);
        }
        return this.classloader.getResource(resource);
    }

    private Enumeration<URL> getResources(String resource) throws IOException {
        if (resource.charAt(0) == '/') {
            resource = resource.substring(1);
        }
        return this.classloader.getResources(resource);
    }

    private Set<String> populateResourcePaths(String path) throws Exception {
        HashSet<String> resources = new HashSet<String>();
        Enumeration<URL> initResources = this.getResources(path);
        while (initResources.hasMoreElements()) {
            URI resourceURI = initResources.nextElement().toURI();
            if (resourceURI.getScheme().equals("file")) {
                this.gatherResourcesWithFileMode(path, resourceURI, resources);
                continue;
            }
            if (!resourceURI.getScheme().equals("jar")) continue;
            this.gatherResourcesWithJarMode(path, resourceURI, resources);
        }
        return resources;
    }

    private void gatherResourcesWithFileMode(String path, URI resourceURI, Set<String> resources) {
        String[] list;
        File file = new File(resourceURI);
        for (String filename : list = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.charAt(0) != '.';
            }
        })) {
            resources.add(path + filename);
        }
    }

    private void gatherResourcesWithJarMode(String path, URI resourceURI, Set<String> resources) {
        String resourceURIAsString = resourceURI.toASCIIString();
        int pathDelim = resourceURIAsString.indexOf(33);
        String zipFile = resourceURIAsString.substring("jar:file:/".length(), pathDelim != -1 ? pathDelim : resourceURIAsString.length());
        try (ZipFile file = new ZipFile(zipFile);){
            Object pathToCompare = path;
            if (((String)pathToCompare).charAt(0) == '/') {
                pathToCompare = ((String)pathToCompare).substring(1, ((String)pathToCompare).length());
            }
            if (!((String)pathToCompare).endsWith("/")) {
                pathToCompare = (String)pathToCompare + "/";
            }
            Enumeration<? extends ZipEntry> e = file.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith((String)pathToCompare) || entry.getName().equals(pathToCompare)) continue;
                resources.add("/" + entry.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

