/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.appserv.connectors.internal.spi.ConnectionManager;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.allocator.ConnectorAllocator;
import com.sun.enterprise.resource.allocator.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.allocator.NoTxConnectorAllocator;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.RetryableUnavailableException;
import jakarta.resource.spi.SecurityException;
import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogDomains.getLogger(ConnectionManagerImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final StringManager I18N = StringManager.getManager(ConnectionManagerImpl.class);
    protected SimpleJndiName jndiName;
    protected SimpleJndiName logicalName;
    protected PoolInfo poolInfo;
    protected ResourceInfo resourceInfo;
    protected String rarName;
    private transient BindableResource resourceConfiguration;
    protected ResourcePrincipalDescriptor defaultResourcePrincipalDescriptor;

    public ConnectionManagerImpl(PoolInfo poolInfo, ResourceInfo resourceInfo) {
        this.poolInfo = poolInfo;
        this.resourceInfo = resourceInfo;
    }

    public void setJndiName(SimpleJndiName jndiName) {
        this.jndiName = jndiName;
    }

    public SimpleJndiName getJndiName() {
        return this.jndiName;
    }

    public void setLogicalName(SimpleJndiName logicalName) {
        this.logicalName = logicalName;
    }

    public SimpleJndiName getLogicalName() {
        return this.logicalName;
    }

    public Object allocateNonTxConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        SimpleJndiName localJndiName;
        LOG.finest("Allocating NonTxConnection");
        if (this.jndiName.hasSuffix("__nontx")) {
            localJndiName = this.jndiName;
            LOG.finest("lookup happened from a __nontx datasource directly");
        } else {
            localJndiName = new SimpleJndiName(String.valueOf(this.jndiName) + "__nontx");
            LOG.finest("Adding __nontx to jndiname");
        }
        return this.allocateConnection(mcf, connectionRequestInfo, localJndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, this.jndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, SimpleJndiName jndiNameToUse) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, jndiNameToUse, null);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, SimpleJndiName jndiNameToUse, Object connection) throws ResourceException {
        AuthenticationService authenticationService;
        String shareableStr;
        LOG.log(Level.FINEST, "allocateConnection(mcf={0}, cxRequestInfo={1}, jndiNameToUse={2}, connection={3})", new Object[]{mcf, cxRequestInfo, jndiNameToUse, connection});
        this.validateResourceAndPool();
        PoolManager poolmgr = ConnectorRuntime.getRuntime().getPoolManager();
        boolean resourceShareable = true;
        ResourceReferenceDescriptor resourceReferenceDescriptor = poolmgr.getResourceReference(jndiNameToUse, this.logicalName);
        if (resourceReferenceDescriptor != null && (shareableStr = resourceReferenceDescriptor.getSharingScope()).equals("Unshareable")) {
            resourceShareable = false;
        }
        if (resourceReferenceDescriptor == null) {
            LOG.log(Level.FINE, "poolmgr.no_resource_reference", jndiNameToUse);
            return this.internalGetConnection(mcf, this.defaultResourcePrincipalDescriptor, cxRequestInfo, resourceShareable, jndiNameToUse, connection, true);
        }
        String authorization = resourceReferenceDescriptor.getAuthorization();
        if (authorization.equals("Application")) {
            if (cxRequestInfo == null) {
                throw new ResourceException(I18N.getString("con_mgr.null_userpass"));
            }
            ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolInfo);
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable, jndiNameToUse, connection, false);
        }
        ResourcePrincipalDescriptor resourcePrincipalDescriptor = null;
        Set principalSet = null;
        Principal callerPrincipal = null;
        SecurityContext securityContext = null;
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        if (connectorRuntime.isServer() && (securityContext = SecurityContext.getCurrent()) != null && (callerPrincipal = securityContext.getCallerPrincipal()) != null && (principalSet = securityContext.getPrincipalSet()) != null && (authenticationService = connectorRuntime.getAuthenticationService(this.rarName, this.poolInfo)) != null) {
            resourcePrincipalDescriptor = authenticationService.mapPrincipal(callerPrincipal, principalSet);
        }
        if (resourcePrincipalDescriptor == null) {
            resourcePrincipalDescriptor = resourceReferenceDescriptor.getResourcePrincipal();
            if (resourcePrincipalDescriptor == null) {
                LOG.log(Level.FINE, "default-resource-principal not specified for {0}. Defaulting to user/password specified in the pool", jndiNameToUse);
                resourcePrincipalDescriptor = this.defaultResourcePrincipalDescriptor;
            } else if (!resourcePrincipalDescriptor.equals((Object)this.defaultResourcePrincipalDescriptor)) {
                ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolInfo);
            }
        }
        return this.internalGetConnection(mcf, resourcePrincipalDescriptor, cxRequestInfo, resourceShareable, jndiNameToUse, connection, false);
    }

    protected Object internalGetConnection(ManagedConnectionFactory mcf, ResourcePrincipalDescriptor prin, ConnectionRequestInfo cxRequestInfo, boolean shareable, SimpleJndiName jndiNameToUse, Object connection, boolean isUnknownAuth) throws ResourceException {
        try {
            PoolManager poolManager = ConnectorRuntime.getRuntime().getPoolManager();
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            PoolMetaData poolMetaData = registry.getPoolMetaData(this.poolInfo);
            ResourceSpec resourceSpec = new ResourceSpec(jndiNameToUse, 1, poolMetaData);
            resourceSpec.setPoolInfo(this.poolInfo);
            ManagedConnectionFactory freshManagedConnectionFactory = poolMetaData.getMCF();
            if (!freshManagedConnectionFactory.equals((Object)mcf)) {
                LOG.info("conmgr.mcf_not_equal");
            }
            ConnectorDescriptor rarConnectorDescriptor = registry.getDescriptor(this.rarName);
            Subject subject = null;
            ClientSecurityInfo info = null;
            if (isUnknownAuth && this.rarName.equals("jmsra") && !poolMetaData.isAuthCredentialsDefinedInPool()) {
                subject = ConnectionPoolObjectsUtils.createSubject(mcf, null);
            } else if (prin == null) {
                info = new ClientSecurityInfo(cxRequestInfo);
            } else {
                info = new ClientSecurityInfo(prin);
                subject = prin.equals((Object)this.defaultResourcePrincipalDescriptor) ? poolMetaData.getSubject() : ConnectionPoolObjectsUtils.createSubject(mcf, prin);
            }
            int txLevel = poolMetaData.getTransactionSupport();
            LOG.log(Level.FINE, "Providing connection: poolName={0}, txLevel={1}", new Object[]{this.poolInfo, txLevel});
            if (connection != null) {
                resourceSpec.setConnectionToAssociate(connection);
            }
            return this.getResource(txLevel, poolManager, mcf, resourceSpec, subject, cxRequestInfo, info, rarConnectorDescriptor, shareable);
        }
        catch (PoolingException e) {
            this.unwrapSecurityException(e);
            throw new ResourceAllocationException(MessageFormat.format("Failed to obtain/create connection from connection pool [{0}]. Reason: {1}", this.poolInfo.getName(), e.getMessage()), (Throwable)e);
        }
    }

    private void unwrapSecurityException(Throwable ex) throws ResourceException {
        if (ex != null) {
            if (ex instanceof SecurityException) {
                LOG.log(Level.WARNING, "poolmgr.get_connection_failure", new Object[]{this.poolInfo, ex});
                throw (SecurityException)ex;
            }
            this.unwrapSecurityException(ex.getCause());
        }
    }

    private Object getResource(int txLevel, PoolManager poolManager, ManagedConnectionFactory mcf, ResourceSpec resourceSpec, Subject subject, ConnectionRequestInfo connectionRequestInfo, ClientSecurityInfo info, ConnectorDescriptor descriptor, boolean shareable) throws PoolingException, IllegalStateException, RetryableUnavailableException {
        AbstractConnectorAllocator resourceAllocator;
        switch (txLevel) {
            case 0: {
                resourceAllocator = new NoTxConnectorAllocator(poolManager, mcf, resourceSpec, subject, connectionRequestInfo, info, descriptor);
                break;
            }
            case 1: {
                resourceAllocator = new LocalTxConnectorAllocator(poolManager, mcf, resourceSpec, subject, connectionRequestInfo, info, descriptor, shareable);
                break;
            }
            case 2: {
                if (this.rarName.equals("jmsra")) {
                    shareable = false;
                }
                resourceSpec.markAsXA();
                resourceAllocator = new ConnectorAllocator(poolManager, mcf, resourceSpec, subject, connectionRequestInfo, info, descriptor, shareable);
                break;
            }
            default: {
                String i18nMsg = I18N.getString("con_mgr.illegal_tx_level", (Object)(txLevel + " "));
                throw new IllegalStateException(i18nMsg);
            }
        }
        return poolManager.getResource(resourceSpec, resourceAllocator, info);
    }

    public void setRarName(String _rarName) {
        this.rarName = _rarName;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void initialize() throws ConnectorRuntimeException {
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        if (runtime.isNonACCRuntime()) {
            this.jndiName = ConnectorsUtil.getPMJndiName((SimpleJndiName)this.jndiName);
        }
        this.defaultResourcePrincipalDescriptor = ConnectorRegistry.getInstance().getPoolMetaData(this.poolInfo).getResourcePrincipal();
    }

    private void validateResourceAndPool() throws ResourceException {
        ResourceInfo resInfo = this.resourceInfo;
        ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (!registry.isResourceDeployed(resInfo)) {
            LOG.log(Level.FINEST, "resourceInfo not found in connector-registry: {0}", resInfo);
            boolean isDefaultResource = false;
            boolean isSunRAResource = false;
            ConnectorDescriptor descriptor = registry.getDescriptor(this.rarName);
            if (descriptor != null) {
                ResourceAdapter rar;
                isDefaultResource = descriptor.getDefaultResourcesNames().contains(resInfo.getName());
                if (descriptor.getSunDescriptor() != null && (rar = descriptor.getSunDescriptor().getResourceAdapter()) != null) {
                    SimpleJndiName sunRAJndiName = (SimpleJndiName)rar.getValue("JndiName");
                    isSunRAResource = resInfo.getName().equals((Object)sunRAJndiName);
                }
            }
            if (!(!runtime.isServer() && !runtime.isEmbedded() || resInfo.getName().contains("__datasource_definition/") || isDefaultResource || isSunRAResource)) {
                SimpleJndiName nonPrefixedName;
                String suffix;
                if (this.resourceConfiguration == null) {
                    this.resourceConfiguration = resourcesUtil.getResource(resInfo, BindableResource.class);
                    if (this.resourceConfiguration == null && (suffix = ConnectorsUtil.getValidSuffix((SimpleJndiName)resInfo.getName())) != null) {
                        nonPrefixedName = resInfo.getName().removeSuffix(suffix);
                        resInfo = new ResourceInfo(nonPrefixedName, resInfo.getApplicationName(), resInfo.getModuleName());
                        this.resourceConfiguration = resourcesUtil.getResource(resInfo, BindableResource.class);
                    }
                } else {
                    suffix = ConnectorsUtil.getValidSuffix((SimpleJndiName)resInfo.getName());
                    if (suffix != null) {
                        nonPrefixedName = resInfo.getName().removeSuffix(suffix);
                        resInfo = new ResourceInfo(nonPrefixedName, resInfo.getApplicationName(), resInfo.getModuleName());
                    }
                }
                if (this.resourceConfiguration == null) {
                    throw new ResourceException("No such resource: " + String.valueOf(resInfo));
                }
                if (!resourcesUtil.isEnabled(this.resourceConfiguration, resInfo)) {
                    throw new ResourceException(String.valueOf(resInfo) + " is not enabled");
                }
            }
        }
        if (registry.getPoolMetaData(this.poolInfo) == null) {
            String msg = I18N.getString("con_mgr.no_pool_meta_data", (Object)this.poolInfo);
            throw new ResourceException(String.valueOf(this.poolInfo) + ": " + msg);
        }
    }
}

