/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.util.ConnectionPoolReconfigHelper;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ConnectorDescriptorInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String rarName;
    private String resourceAdapterClass;
    private String connectionDefinitionName;
    private String managedConnectionFactoryClass;
    private String connectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionClass;
    private String connectionInterface;
    private Set<ConnectorConfigProperty> mcfConfigProperties = new LinkedHashSet<ConnectorConfigProperty>();
    private Set<ConnectorConfigProperty> resourceAdapterConfigProperties = new LinkedHashSet<ConnectorConfigProperty>();

    public ConnectorDescriptorInfo() {
    }

    public ConnectorDescriptorInfo doClone() {
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setMCFConfigProperties(this.mcfConfigProperties);
        cdi.setResourceAdapterConfigProperties(this.resourceAdapterConfigProperties);
        cdi.setRarName(this.rarName);
        cdi.setResourceAdapterClassName(this.resourceAdapterClass);
        cdi.setConnectionDefinitionName(this.connectionDefinitionName);
        cdi.setManagedConnectionFactoryClass(this.managedConnectionFactoryClass);
        cdi.setConnectionFactoryClass(this.connectionFactoryClass);
        cdi.setConnectionFactoryInterface(this.connectionFactoryInterface);
        cdi.setConnectionClass(this.connectionClass);
        cdi.setConnectionInterface(this.connectionInterface);
        return cdi;
    }

    public ConnectorDescriptorInfo(ConnectorConfigProperty[] mcfConfigProperties, ConnectorConfigProperty[] resourceAdapterConfigProperties) {
        this();
        if (mcfConfigProperties != null) {
            for (ConnectorConfigProperty mcfConfigProperty : mcfConfigProperties) {
                this.mcfConfigProperties.add(mcfConfigProperty);
            }
            if (resourceAdapterConfigProperties != null) {
                for (ConnectorConfigProperty mcfConfigProperty : mcfConfigProperties) {
                    this.resourceAdapterConfigProperties.add(mcfConfigProperty);
                }
            }
        }
    }

    public void addMCFConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.mcfConfigProperties.add(configProperty);
        }
    }

    public void removeMCFConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.mcfConfigProperties.remove(configProperty);
        }
    }

    public void setMCFConfigProperties(Set<ConnectorConfigProperty> configProperties) {
        this.mcfConfigProperties = configProperties;
    }

    public void setMCFConfigProperties(ConnectorConfigProperty[] configProperties) {
        if (configProperties != null) {
            for (ConnectorConfigProperty element : configProperties) {
                this.mcfConfigProperties.add(element);
            }
        }
    }

    public Set<ConnectorConfigProperty> getMCFConfigProperties() {
        return this.mcfConfigProperties;
    }

    public void addResourceAdapterConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.resourceAdapterConfigProperties.add(configProperty);
        }
    }

    public void removeResourceAdapterConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.resourceAdapterConfigProperties.remove(configProperty);
        }
    }

    public void setResourceAdapterConfigProperties(Set<ConnectorConfigProperty> configProperties) {
        this.resourceAdapterConfigProperties = configProperties;
    }

    public void setResourceAdapterConfigProperties(ConnectorConfigProperty[] configProperties) {
        if (configProperties != null) {
            for (ConnectorConfigProperty configProperty : configProperties) {
                this.resourceAdapterConfigProperties.add(configProperty);
            }
        }
    }

    public Set<ConnectorConfigProperty> getResourceAdapterConfigProperties() {
        return this.resourceAdapterConfigProperties;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void setRarName(String rarName) {
        this.rarName = rarName;
    }

    public String getResourceAdapterClassName() {
        return this.resourceAdapterClass;
    }

    public void setResourceAdapterClassName(String resourceAdapterClass) {
        this.resourceAdapterClass = resourceAdapterClass;
    }

    public String getConnectionDefinitionName() {
        return this.connectionDefinitionName;
    }

    public void setConnectionDefinitionName(String connectionDefinitionName) {
        this.connectionDefinitionName = connectionDefinitionName;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionClass() {
        return this.connectionClass;
    }

    public void setConnectionClass(String connectionClass) {
        this.connectionClass = connectionClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    public ConnectionPoolReconfigHelper.ReconfigAction compareMCFConfigProperties(ConnectorDescriptorInfo cdi) {
        return this.compareMCFConfigProperties(cdi, new HashSet<String>());
    }

    public ConnectionPoolReconfigHelper.ReconfigAction compareMCFConfigProperties(ConnectorDescriptorInfo cdi, Set<String> excluded) {
        Set<ConnectorConfigProperty> mcfConfigProps = cdi.getMCFConfigProperties();
        if (mcfConfigProps.size() != this.mcfConfigProperties.size()) {
            return ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL;
        }
        boolean same = false;
        for (ConnectorConfigProperty mcfConfigProp : mcfConfigProps) {
            if (excluded.contains(mcfConfigProp.getName())) continue;
            for (ConnectorConfigProperty property : this.mcfConfigProperties) {
                if (!this.isEnvPropEqual(mcfConfigProp, property)) continue;
                same = true;
                break;
            }
            if (!same) {
                return ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL;
            }
            same = false;
        }
        return ConnectionPoolReconfigHelper.ReconfigAction.NO_OP;
    }

    private boolean isEnvPropEqual(ConnectorConfigProperty e1, ConnectorConfigProperty e2) {
        return e1 != null && e2 != null && e1.getName() != null && e2.getName() != null && e1.getName().equals(e2.getName()) && e1.getValue() != null && e2.getValue() != null && e1.getValue().equals(e2.getValue());
    }
}

