/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.logging.GMSLogDomain;
import org.glassfish.shoal.gms.mgmt.ClusterManager;
import org.glassfish.shoal.gms.mgmt.ClusterViewEvent;
import org.glassfish.shoal.gms.mgmt.ClusterViewEvents;
import org.glassfish.shoal.gms.mgmt.MasterNode;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MulticastMessageSender;

public class ReliableMulticast {
    private static final Logger logger = GMSLogDomain.getMcastLogger();
    private static final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private final long DEFAULT_EXPIRE_DURATION_MS;
    private final long DEFAULT_EXPIRE_REAPING_FREQUENCY;
    private MulticastMessageSender sender = null;
    private final Timer time;
    private final ConcurrentHashMap<Long, ReliableBroadcast> sendHistory = new ConcurrentHashMap();
    private ClusterManager manager = null;

    public int sendHistorySize() {
        return this.sendHistory.size();
    }

    void add(Message msg, long expireDuration_ms) {
        long seqId = MasterNode.getMasterViewSequenceID(msg);
        if (seqId != -1L) {
            ReliableBroadcast rb = new ReliableBroadcast(msg, expireDuration_ms);
            this.sendHistory.put(seqId, rb);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("ReliableBroadcast.add msg[" + ReliableMulticast.clusterViewEventMsgToString(msg) + "]");
            }
        }
    }

    private static String clusterViewEventMsgToString(Message msg) {
        StringBuilder sb = new StringBuilder(40);
        try {
            long seqId = MasterNode.getMasterViewSequenceID(msg);
            Object element = msg.getMessageElement("VCE");
            ClusterViewEvents type = null;
            String cveType = null;
            String memberName = null;
            PeerID peerId = null;
            if (element != null && element instanceof ClusterViewEvent) {
                ClusterViewEvent cve = (ClusterViewEvent)element;
                type = cve.getEvent();
                memberName = cve.getAdvertisement().getName();
                peerId = cve.getAdvertisement().getID();
                cveType = type.toString();
                sb.append("broadcast seq id:").append(seqId).append(" viewChangeEvent:").append(cveType).append(" member:").append(memberName).append(" peerId:").append(peerId);
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void processExpired() {
        int numExpired = 0;
        Set<Map.Entry<Long, ReliableBroadcast>> entrySet = this.sendHistory.entrySet();
        for (Map.Entry<Long, ReliableBroadcast> entry : entrySet) {
            ReliableBroadcast rb = entry.getValue();
            if (!rb.isExpired()) continue;
            ++numExpired;
            entrySet.remove(entry);
            if (rb.resends <= 0 || !logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "expire resent msg with masterViewSeqID=" + String.valueOf(entry.getKey()) + " resent:" + rb.resends);
        }
        if (numExpired > 0 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "processExpired: expired " + numExpired + " masterViewSeqID messages");
        }
    }

    public boolean resend(PeerID to, Long seqId) throws IOException {
        boolean result = false;
        ReliableBroadcast rb = this.sendHistory.get(seqId);
        if (rb != null) {
            Message msg = rb.msg;
            msg.addMessageElement("RESEND", Boolean.TRUE);
            result = this.manager.getNetworkManager().send(to, rb.msg);
            ++rb.resends;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "mgmt.reliable.mcast.resend", new Object[]{seqId, to.getInstanceName(), to.getGroupName(), rb.resends, ReliableMulticast.clusterViewEventMsgToString(msg)});
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "mgmt.reliable.mcast.resend.failed", new Object[]{seqId, to.getInstanceName(), to.getGroupName()});
        }
        return result;
    }

    public ReliableMulticast(ClusterManager manager) {
        this.DEFAULT_EXPIRE_DURATION_MS = 12000L;
        this.DEFAULT_EXPIRE_REAPING_FREQUENCY = this.DEFAULT_EXPIRE_DURATION_MS + this.DEFAULT_EXPIRE_DURATION_MS / 2L;
        this.manager = manager;
        this.sender = manager.getNetworkManager().getMulticastMessageSender();
        Reaper reaper = new Reaper(this);
        this.time = new Timer();
        this.time.schedule((TimerTask)reaper, this.DEFAULT_EXPIRE_REAPING_FREQUENCY, this.DEFAULT_EXPIRE_REAPING_FREQUENCY);
    }

    public ReliableMulticast(long expire_duration_ms) {
        this.DEFAULT_EXPIRE_DURATION_MS = expire_duration_ms;
        this.DEFAULT_EXPIRE_REAPING_FREQUENCY = this.DEFAULT_EXPIRE_DURATION_MS + this.DEFAULT_EXPIRE_DURATION_MS / 2L;
        Reaper reaper = new Reaper(this);
        this.time = new Timer();
        this.time.schedule((TimerTask)reaper, this.DEFAULT_EXPIRE_REAPING_FREQUENCY, this.DEFAULT_EXPIRE_REAPING_FREQUENCY);
    }

    public void stop() {
        this.time.cancel();
    }

    public boolean broadcast(Message msg) throws IOException {
        boolean result = false;
        if (this.sender == null) {
            throw new IOException("multicast sender is null");
        }
        result = this.sender.broadcast(msg);
        if (result) {
            this.add(msg, this.DEFAULT_EXPIRE_DURATION_MS);
        }
        return result;
    }

    private static class ReliableBroadcast {
        private final Message msg;
        private final long startTime;
        private final long expirationTime_ms;
        private int resends;

        public ReliableBroadcast(Message msg, long expireDuration_ms) {
            this.msg = msg;
            this.startTime = System.currentTimeMillis();
            this.expirationTime_ms = this.startTime + expireDuration_ms;
            this.resends = 0;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime_ms;
        }
    }

    static class Reaper
    extends TimerTask {
        private final ReliableMulticast rb;

        public Reaper(ReliableMulticast rb) {
            this.rb = rb;
        }

        @Override
        public void run() {
            this.rb.processExpired();
        }
    }
}

