/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend.constantpool;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPoolEntry;

public class MethodHandleCPInfo
extends ConstantPoolEntry {
    private ConstantPoolEntry reference;
    private ReferenceKind referenceKind;
    private int referenceIndex;
    private int nameAndTypeIndex;

    public MethodHandleCPInfo() {
        super(15, 1);
    }

    @Override
    public void read(DataInputStream cpStream) throws IOException {
        this.referenceKind = ReferenceKind.values()[cpStream.readUnsignedByte() - 1];
        this.referenceIndex = cpStream.readUnsignedShort();
    }

    public String toString() {
        String value = this.isResolved() ? "MethodHandle : " + this.reference.toString() : "MethodHandle : Reference kind = " + (Object)((Object)this.referenceKind) + "Reference index = " + this.referenceIndex;
        return value;
    }

    @Override
    public void resolve(ConstantPool constantPool) {
        this.reference = constantPool.getEntry(this.referenceIndex);
        this.reference.resolve(constantPool);
        super.resolve(constantPool);
    }

    public static enum ReferenceKind {
        REF_getField(1),
        REF_getStatic(2),
        REF_putField(3),
        REF_putStatic(4),
        REF_invokeVirtual(5),
        REF_invokeStatic(6),
        REF_invokeSpecial(7),
        REF_newInvokeSpecial(8),
        REF_invokeInterface(9);

        private final int referenceKind;

        private ReferenceKind(int referenceKind) {
            this.referenceKind = referenceKind;
        }
    }
}

