/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class NewMasterBrokerHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NewMasterBrokerHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "NewMasterBrokerHandler");
        }
        if (pkt.getType() == 51) {
            this.handleNewMasterBrokerPrepare(sender, pkt);
        } else if (pkt.getType() == 52) {
            this.handleNewMasterBrokerPrepareReply(sender, pkt);
        } else if (pkt.getType() == 53) {
            this.handleNewMasterBroker(sender, pkt);
        } else if (pkt.getType() == 54) {
            this.handleNewMasterBrokerReply(sender, pkt);
        } else {
            this.logger.log(16, "NewMasterBrokerHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    private void handleNewMasterBrokerPrepare(BrokerAddress sender, GPacket pkt) {
        String reason;
        int status;
        block4: {
            status = 200;
            reason = null;
            try {
                this.p.receivedNewMasterBrokerPrepare(sender, pkt);
            }
            catch (Exception e) {
                status = 500;
                reason = e.getMessage();
                if (e instanceof BrokerException) break block4;
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
                reason = this.br.getKString("B3269", args);
                this.logger.log(32, reason);
            }
        }
        ClusterNewMasterBrokerPrepareInfo nmpi = ClusterNewMasterBrokerPrepareInfo.newInstance(pkt, this.c);
        GPacket reply = nmpi.getReplyGPacket(status, reason);
        try {
            this.c.unicast(sender, reply);
        }
        catch (Exception e) {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(52), sender.toString(), nmpi.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", args), e);
        }
    }

    private void handleNewMasterBroker(BrokerAddress sender, GPacket pkt) {
        String reason;
        int status;
        block4: {
            status = 200;
            reason = null;
            try {
                this.p.receivedNewMasterBroker(sender, pkt);
            }
            catch (Exception e) {
                status = 500;
                reason = e.getMessage();
                if (e instanceof BrokerException) break block4;
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
                reason = this.br.getKString("B3269", args);
                this.logger.log(32, reason);
            }
        }
        ClusterNewMasterBrokerInfo nmi = ClusterNewMasterBrokerInfo.newInstance(pkt, this.c);
        GPacket reply = nmi.getReplyGPacket(status, reason);
        try {
            this.c.unicast(sender, reply);
        }
        catch (Exception e) {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(54), sender.toString(), nmi.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", args), e);
        }
    }

    private void handleNewMasterBrokerPrepareReply(BrokerAddress sender, GPacket pkt) {
        this.p.receivedNewMasterBrokerPrepareReply(sender, pkt);
    }

    private void handleNewMasterBrokerReply(BrokerAddress sender, GPacket pkt) {
        this.p.receivedNewMasterBrokerReply(sender, pkt);
    }
}

