/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar.commandline;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class WordWrapCollector
implements Collector<String, StringBuilder, String> {
    private final int MAX_LINE_LENGTH;
    private final String HELP_LINE_INDENT;
    private int characterCount;

    public WordWrapCollector(int maxLineLength, int initialIndent, String otherLinesIndentText) {
        this.MAX_LINE_LENGTH = maxLineLength;
        this.HELP_LINE_INDENT = otherLinesIndentText;
        this.characterCount = initialIndent;
    }

    @Override
    public Supplier<StringBuilder> supplier() {
        return StringBuilder::new;
    }

    @Override
    public BiConsumer<StringBuilder, String> accumulator() {
        return (assembly, item) -> {
            for (String word : item.split(" ")) {
                this.appendItem((StringBuilder)assembly, word);
            }
        };
    }

    @Override
    public BinaryOperator<StringBuilder> combiner() {
        return (sb1, sb2) -> sb1.append((CharSequence)sb2);
    }

    @Override
    public Function<StringBuilder, String> finisher() {
        return StringBuilder::toString;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of();
    }

    private static char lastChar(StringBuilder assembly) {
        return assembly.charAt(assembly.length() - 1);
    }

    private void appendItem(StringBuilder assembly, String item) {
        String modifiedItem = this.wrapWord(item);
        if (!(assembly.length() == 0 || Set.of(Character.valueOf('\n'), Character.valueOf(' ')).contains(Character.valueOf(WordWrapCollector.lastChar(assembly))) || modifiedItem.startsWith("\n") || modifiedItem.startsWith(" "))) {
            assembly.append(" ");
        }
        assembly.append(modifiedItem);
    }

    private String wrapWord(String word) {
        String[] lines = word.split("\n", -1);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            if (!first) {
                sb.append("\n").append(this.HELP_LINE_INDENT);
                this.characterCount = this.HELP_LINE_INDENT.length();
            }
            this.characterCount += line.length() + 1;
            if (this.characterCount > this.MAX_LINE_LENGTH) {
                String modifiedLine = this.HELP_LINE_INDENT + line;
                this.characterCount = modifiedLine.length();
                sb.append("\n").append(modifiedLine);
            } else {
                sb.append(line);
            }
            first = false;
        }
        return sb.toString();
    }
}

