/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=ConnectionFactoryDefinitionDescriptor.class)
public class ConnectionFactoryDefinitionDeployer
implements ResourceDeployer<ConnectionFactoryDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ConnectionFactoryDefinitionDeployer.class.getName());
    private static final String PROPERTY_PREFIX = "org.glassfish.connector-connection-pool.";
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;

    public void deployResource(ConnectionFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)JavaEEResourceType.CFDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        LOG.log(System.Logger.Level.INFO, "Deploying resource [{0}] with pool [{1}].", resourceName, poolName);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(resource, poolName);
        this.getDeployer(connectorCp).deployResource((Object)connectorCp);
        MyConnectorResource connectorResource = new MyConnectorResource(this, poolName, resourceName);
        this.getDeployer(connectorResource).deployResource((Object)connectorResource);
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private ConnectionFactoryProperty convertProperty(String name, String value) {
        return new ConnectionFactoryProperty(this, name, value);
    }

    public void undeployResource(ConnectionFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)JavaEEResourceType.CFDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        LOG.log(System.Logger.Level.INFO, "Undeploying resource [{0}] with pool [{1}].", resourceName, poolName);
        MyConnectorResource connectorResource = new MyConnectorResource(this, poolName, resourceName);
        this.getDeployer(connectorResource).undeployResource((Object)connectorResource);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(resource, poolName);
        this.getDeployer(connectorCp).undeployResource((Object)connectorCp);
    }

    public void enableResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for connection-factory-definition type");
    }

    public void disableResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for connection-factory-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectionFactoryDefinitionDescriptor;
    }

    class MyConnectorConnectionPool
    extends FakeConfigBean
    implements ConnectorConnectionPool {
        private final ConnectionFactoryDefinitionDescriptor desc;
        private final SimpleJndiName name;

        public MyConnectorConnectionPool(ConnectionFactoryDefinitionDescriptor desc, SimpleJndiName name) {
            super(ConnectionFactoryDefinitionDeployer.this);
            this.desc = desc;
            this.name = name;
        }

        public String getObjectType() {
            return "user";
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name.toString();
        }

        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            return minPoolSize < 0 ? "8" : Integer.toString(minPoolSize);
        }

        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            return maxPoolSize < 0 ? "32" : Integer.toString(maxPoolSize);
        }

        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxWaitTimeInMillis() {
            String maxWaitTimeInMillis = this.desc.getProperty("org.glassfish.connector-connection-pool.max-wait-time-in-millis");
            return maxWaitTimeInMillis == null || maxWaitTimeInMillis.isEmpty() ? "60000" : maxWaitTimeInMillis;
        }

        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        public String getPoolResizeQuantity() {
            String poolResizeQuantity = this.desc.getProperty("org.glassfish.connector-connection-pool.pool-resize-quantity");
            return poolResizeQuantity == null || poolResizeQuantity.isEmpty() ? "2" : poolResizeQuantity;
        }

        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        public String getIdleTimeoutInSeconds() {
            String timeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.idle-timeout-in-seconds");
            return timeoutInSeconds == null || timeoutInSeconds.isEmpty() ? "300" : timeoutInSeconds;
        }

        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getIsConnectionValidationRequired() {
            String isRequired = this.desc.getProperty("org.glassfish.connector-connection-pool.is-connection-validation-required");
            return isRequired == null || isRequired.isEmpty() ? "false" : isRequired;
        }

        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        public String getResourceAdapterName() {
            return this.desc.getResourceAdapter();
        }

        public void setResourceAdapterName(String value) throws PropertyVetoException {
        }

        public String getConnectionDefinitionName() {
            return this.desc.getInterfaceName();
        }

        public void setConnectionDefinitionName(String value) throws PropertyVetoException {
        }

        public String getFailAllConnections() {
            String failAllConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.fail-all-connections");
            return failAllConnections == null || failAllConnections.isEmpty() ? "false" : failAllConnections;
        }

        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        public String getTransactionSupport() {
            return this.desc.getTransactionSupport();
        }

        public void setTransactionSupport(String value) throws PropertyVetoException {
        }

        public String getValidateAtmostOncePeriodInSeconds() {
            String timeInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.validate-at-most-once-period-in-seconds");
            return timeInSeconds == null || timeInSeconds.isEmpty() ? "0" : timeInSeconds;
        }

        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakTimeoutInSeconds() {
            String timeInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-timeout-in-seconds");
            return timeInSeconds == null || timeInSeconds.isEmpty() ? "0" : timeInSeconds;
        }

        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakReclaim() {
            String conLeakReclaim = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-reclaim");
            return conLeakReclaim == null || conLeakReclaim.isEmpty() ? "0" : conLeakReclaim;
        }

        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryAttempts() {
            String attemptCount = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-attempts");
            return attemptCount == null || attemptCount.isEmpty() ? "0" : attemptCount;
        }

        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryIntervalInSeconds() {
            String interval = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-interval-in-seconds");
            return interval == null || interval.isEmpty() ? "0" : interval;
        }

        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionEnlistment() {
            String lazy = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-enlistment");
            return lazy == null || lazy.isEmpty() ? "false" : lazy;
        }

        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionAssociation() {
            String lazy = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-association");
            return lazy == null || lazy.isEmpty() ? "false" : lazy;
        }

        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        public String getAssociateWithThread() {
            String associateWithThread = this.desc.getProperty("org.glassfish.connector-connection-pool.associate-with-thread");
            return associateWithThread == null || associateWithThread.isEmpty() ? "false" : associateWithThread;
        }

        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        public String getPooling() {
            String pooling = this.desc.getProperty("org.glassfish.connector-connection-pool.pooling");
            return pooling == null || pooling.isEmpty() ? "true" : pooling;
        }

        public void setPooling(String value) throws PropertyVetoException {
        }

        public String getMatchConnections() {
            String matchConn = this.desc.getProperty("org.glassfish.connector-connection-pool.match-connections");
            return matchConn == null || matchConn.isEmpty() ? "true" : matchConn;
        }

        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        public String getMaxConnectionUsageCount() {
            String count = this.desc.getProperty("org.glassfish.connector-connection-pool.max-connection-usage-count");
            return count == null || count.isEmpty() ? "0" : count;
        }

        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> connectionFactoryProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(ConnectionFactoryDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                ConnectionFactoryProperty dp = ConnectionFactoryDefinitionDeployer.this.convertProperty(key, value);
                connectionFactoryProperties.add(dp);
            }
            return connectionFactoryProperties;
        }

        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new ConnectionFactoryProperty(ConnectionFactoryDefinitionDeployer.this, name, value);
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = this.desc.getProperty(name);
            return value == null ? defaultValue : value;
        }

        public void injectedInto(Object o) {
        }

        public String getName() {
            return this.name.toString();
        }

        public void setName(String value) throws PropertyVetoException {
        }

        public String getPing() {
            String ping = this.desc.getProperty("org.glassfish.connector-connection-pool.ping");
            return ping == null || ping.isEmpty() ? "false" : ping;
        }

        public void setPing(String value) throws PropertyVetoException {
        }

        public List<SecurityMap> getSecurityMap() {
            return new ArrayList<SecurityMap>(0);
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MyConnectorResource
    extends FakeConfigBean
    implements ConnectorResource {
        private SimpleJndiName poolName;
        private SimpleJndiName jndiName;

        MyConnectorResource(ConnectionFactoryDefinitionDeployer this$0, SimpleJndiName poolName, SimpleJndiName jndiName) {
            super(this$0);
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        public String getPoolName() {
            return this.poolName.toString();
        }

        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = new SimpleJndiName(value);
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.jndiName.toString();
        }

        public String getEnabled() {
            return String.valueOf(true);
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public String getPropertyValue(String name) {
            return null;
        }

        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        public String getJndiName() {
            return this.jndiName.toString();
        }

        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = new SimpleJndiName(value);
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class ConnectionFactoryProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        ConnectionFactoryProperty(ConnectionFactoryDefinitionDeployer this$0, String name, String value) {
            super(this$0);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean(ConnectionFactoryDefinitionDeployer this$0) {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

