/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.store.backing.commands.SimpleAckCommand;
import org.glassfish.shoal.ha.cache.util.CommandResponse;
import org.glassfish.shoal.ha.cache.util.ResponseMediator;

public abstract class AcknowledgedCommand<K, V>
extends Command<K, V> {
    private static final long serialVersionUID = -4027862351560585449L;
    private transient CommandResponse resp;
    private transient Future future;
    private long tokenId;
    private String originatingInstance;

    protected AcknowledgedCommand(byte opCode) {
        super(opCode);
    }

    @Override
    protected boolean beforeTransmit() {
        if (this.dsc.isDoSynchronousReplication()) {
            this.originatingInstance = this.dsc.getInstanceName();
            ResponseMediator respMed = this.dsc.getResponseMediator();
            this.resp = respMed.createCommandResponse();
            this.tokenId = this.resp.getTokenId();
            this.future = this.resp.getFuture();
        }
        return true;
    }

    protected void sendAcknowledgement() {
        try {
            this.dsc.getCommandManager().execute(new SimpleAckCommand(this.originatingInstance, this.tokenId));
        }
        catch (DataStoreException dataStoreException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.dsc.isDoSynchronousReplication());
        if (this.dsc.isDoSynchronousReplication()) {
            out.writeLong(this.tokenId);
            out.writeUTF(this.originatingInstance);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean doSync = in.readBoolean();
        if (doSync) {
            this.tokenId = in.readLong();
            this.originatingInstance = in.readUTF();
        }
    }

    @Override
    public final void onSuccess() {
        if (this.dsc.isDoSynchronousReplication()) {
            try {
                this.waitForAck();
            }
            catch (Exception ex) {
                System.out.println("** Got exception: " + String.valueOf(ex));
            }
        }
    }

    @Override
    public final void onFailure() {
        if (this.dsc.isDoSynchronousReplication()) {
            ResponseMediator respMed = this.dsc.getResponseMediator();
            respMed.removeCommandResponse(this.tokenId);
        }
    }

    private void waitForAck() throws DataStoreException, TimeoutException {
        try {
            this.future.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException tEx) {
            throw tEx;
        }
        catch (Exception inEx) {
            throw new DataStoreException(inEx);
        }
        finally {
            ResponseMediator respMed = this.dsc.getResponseMediator();
            respMed.removeCommandResponse(this.tokenId);
        }
    }
}

