/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.runtime.application.wls.ApplicationParam;
import com.sun.enterprise.deployment.types.EnvironmentPropertyValueTypes;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.WebDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.internal.api.RelativePathResolver;

public class EnvironmentProperty
extends Descriptor
implements InitializationParameter,
ContextParameter,
ApplicationParam,
WebDescriptor,
InjectionCapable {
    private static final long serialVersionUID = 1L;
    static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentProperty.class);
    private String value;
    private String type;
    private Object valueObject;
    private boolean setValueCalled;
    private Set<InjectionTarget> injectionTargets;
    protected SimpleJndiName mappedName;
    protected SimpleJndiName lookupName;

    public EnvironmentProperty() {
    }

    public EnvironmentProperty(String name, String value, String description) {
        this(name, value, description, null);
    }

    public EnvironmentProperty(String name, String value, String description, String type) {
        super(name, description);
        this.value = value;
        this.checkType(type);
        this.type = this.convertPrimitiveTypes(type);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    public String getResolvedValue() {
        return RelativePathResolver.resolvePath((String)this.getValue());
    }

    public final <T> T getResolvedValueObject(Class<T> expectedType) {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return this.getObjectFromString(this.getResolvedValue(), expectedType);
    }

    private void checkType(String type) {
        if (type == null) {
            return;
        }
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t) {
            if (Descriptor.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{type}));
            }
            return;
        }
        boolean allowedType = false;
        for (Class<?> clazz : EnvironmentPropertyValueTypes.ALLOWED_TYPES) {
            if (!clazz.equals(typeClass)) continue;
            allowedType = true;
            break;
        }
        if (typeClass != null && typeClass.isEnum()) {
            allowedType = true;
        }
        if (Descriptor.isBoundsChecking() && !allowedType) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedprprtytype", "{0} is not an allowed property value type", new Object[]{type}));
        }
    }

    public <T> T getValueObject(Class<T> expectedType) {
        return this.getObjectFromString(this.getValue(), expectedType);
    }

    private Class<?> getValueType() {
        if (this.type == null) {
            return String.class;
        }
        try {
            return Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t) {
            throw new IllegalStateException("The type is not reachable for the current classloader: " + this.type, t);
        }
    }

    public void setType(String type) {
        this.checkType(type);
        this.type = this.convertPrimitiveTypes(type);
    }

    private String convertPrimitiveTypes(String type) {
        if (type == null) {
            return type;
        }
        if (type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("char")) {
            return "java.lang.Character";
        }
        return type;
    }

    public String getType() {
        if (this.type == null) {
            return String.class.getName();
        }
        return this.type;
    }

    public void setMappedName(SimpleJndiName mName) {
        this.mappedName = mName;
    }

    public SimpleJndiName getMappedName() {
        return this.mappedName == null ? new SimpleJndiName("") : this.mappedName;
    }

    public void setLookupName(SimpleJndiName lName) {
        this.lookupName = lName;
    }

    public SimpleJndiName getLookupName() {
        return this.lookupName == null ? new SimpleJndiName("") : this.lookupName;
    }

    public boolean hasLookupName() {
        return this.lookupName != null && !this.lookupName.isEmpty();
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.setValueCalled = value != null;
    }

    public boolean isSetValueCalled() {
        return this.setValueCalled;
    }

    public boolean hasContent() {
        return this.setValueCalled || !this.getLookupName().isEmpty() || !this.getMappedName().isEmpty();
    }

    public boolean equals(Object other) {
        return other instanceof EnvironmentProperty && this.getName().equals(((EnvironmentProperty)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append(this.getClass().getSimpleName()).append("[name=").append(this.getName());
        toStringBuffer.append(", type=").append(this.getType()).append(", value=").append(this.getValue());
        toStringBuffer.append(", lookupName=").append(this.getLookupName());
        toStringBuffer.append(", mappedName=").append(this.getMappedName());
        this.printInjectableResourceInfo(toStringBuffer);
        toStringBuffer.append(", description=").append(this.getDescription()).append(']');
    }

    private <T> T getObjectFromString(String string, Class<T> type) {
        T obj;
        if (type == null) {
            type = this.getValueType();
        }
        if ((obj = this.getParsedPrimitiveValue(string, type)) != null) {
            return obj;
        }
        if (string == null || string.isEmpty() && !String.class.equals(type)) {
            return null;
        }
        try {
            if (String.class.equals(type)) {
                return (T)string;
            }
            if (Boolean.class.equals(type)) {
                return (T)Boolean.valueOf(string);
            }
            if (Integer.class.equals(type)) {
                return (T)Integer.valueOf(string);
            }
            if (Double.class.equals(type)) {
                return (T)Double.valueOf(string);
            }
            if (Float.class.equals(type)) {
                return (T)Float.valueOf(string);
            }
            if (Short.class.equals(type)) {
                return (T)Short.valueOf(string);
            }
            if (Byte.class.equals(type)) {
                return (T)Byte.valueOf(string);
            }
            if (Long.class.equals(type)) {
                return (T)Long.valueOf(string);
            }
            if (Character.class.equals(type)) {
                if (string.length() == 1) {
                    return (T)Character.valueOf(string.charAt(0));
                }
                throw new IllegalArgumentException("String cannot be converted to Character: " + string);
            }
            if (SimpleJndiName.class.equals(type)) {
                return (T)SimpleJndiName.of((String)string);
            }
            if (Class.class.equals(type)) {
                return (T)Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && type.isEnum()) {
                return (T)Enum.valueOf(type, string);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncouldnotcreateinstancetype", "Could not create instance of {0} from {1}\n reason: {2}" + String.valueOf(t), new Object[]{type, string, t}));
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionillegaltypeenvproperty", "Illegal type for environment properties: {0}", new Object[]{type}));
    }

    private <T> T getParsedPrimitiveValue(String string, Class<T> type) throws IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("type must not be null! String value was " + string);
        }
        if (type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(string);
        }
        if (type.equals(Long.TYPE)) {
            return (T)Long.valueOf(string);
        }
        if (type.equals(Short.TYPE)) {
            return (T)Short.valueOf(string);
        }
        if (type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(string);
        }
        if (type.equals(Float.TYPE)) {
            return (T)Float.valueOf(string);
        }
        if (type.equals(Double.TYPE)) {
            return (T)Double.valueOf(string);
        }
        if (type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(string);
        }
        if (type.equals(Character.TYPE)) {
            if (string.length() == 1) {
                return (T)Character.valueOf(string.charAt(0));
            }
            throw new IllegalArgumentException(String.valueOf(type) + ": " + string);
        }
        return null;
    }

    public boolean isConflict(EnvironmentProperty other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getType(), other.getType()) || !this.getValue().equals(other.getValue()) || this.isConflictResourceGroup(other));
    }

    protected boolean isConflictResourceGroup(EnvironmentProperty other) {
        return !this.getLookupName().equals((Object)other.getLookupName()) || !this.getMappedName().equals((Object)other.getMappedName());
    }

    @Override
    public void addInjectionTarget(InjectionTarget target) {
        if (this.injectionTargets == null) {
            this.injectionTargets = new HashSet<InjectionTarget>();
        }
        for (InjectionTarget injTarget : this.injectionTargets) {
            if (!injTarget.equals((Object)target)) continue;
            return;
        }
        this.injectionTargets.add(target);
    }

    @Override
    public Set<InjectionTarget> getInjectionTargets() {
        return this.injectionTargets == null ? new HashSet() : this.injectionTargets;
    }

    @Override
    public boolean isInjectable() {
        return this.injectionTargets != null && !this.injectionTargets.isEmpty();
    }

    public boolean hasInjectionTargetFromXml() {
        if (this.injectionTargets != null) {
            for (InjectionTarget injTarget : this.injectionTargets) {
                if (MetadataSource.XML != injTarget.getMetadataSource()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final SimpleJndiName getComponentEnvName() {
        return new SimpleJndiName(this.getName());
    }

    @Override
    public String getInjectResourceType() {
        return this.type;
    }

    @Override
    public void setInjectResourceType(String resourceType) {
        this.type = this.convertPrimitiveTypes(resourceType);
    }

    private StringBuffer printInjectableResourceInfo(StringBuffer toStringBuffer) {
        toStringBuffer.append(", injectableTargets={");
        if (this.isInjectable()) {
            boolean first = true;
            for (InjectionTarget target : this.getInjectionTargets()) {
                if (first) {
                    first = false;
                } else {
                    toStringBuffer.append(", ");
                }
                toStringBuffer.append(target.getClassName()).append('.');
                if (target.isFieldInjectable()) {
                    toStringBuffer.append(target.getFieldName());
                    continue;
                }
                toStringBuffer.append(target.getMethodName()).append("(...)");
            }
        }
        return toStringBuffer.append('}');
    }
}

