/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.BindingOperation;
import com.sun.tools.ws.wsdl.document.Definitions;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Fault;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.Port;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.tools.ws.wsdl.document.Service;
import com.sun.tools.ws.wsdl.document.jaxws.CustomName;
import com.sun.tools.ws.wsdl.document.jaxws.JAXWSBinding;
import com.sun.tools.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.ws.wsdl.document.jaxws.Parameter;
import com.sun.tools.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.ws.wsdl.parser.ContextClassloaderLocal;
import com.sun.tools.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXWSBindingExtensionHandler
extends AbstractExtensionHandler {
    private static final ContextClassloaderLocal<XPathFactory> xpf = new ContextClassloaderLocal<XPathFactory>(){

        @Override
        protected XPathFactory initialValue() throws Exception {
            return XmlUtil.newXPathFactory(false);
        }
    };
    private final XPath xpath = xpf.get().newXPath();

    public JAXWSBindingExtensionHandler(Map<String, AbstractExtensionHandler> extensionHandlerMap) {
        super(extensionHandlerMap);
    }

    @Override
    public String getNamespaceURI() {
        return "https://jakarta.ee/xml/ns/jaxws";
    }

    private boolean parseGlobalJAXWSBindings(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        Element e2;
        String attr;
        context.push();
        context.registerNamespaces(e);
        JAXWSBinding jaxwsBinding = JAXWSBindingExtensionHandler.getJAXWSExtension(parent);
        if (jaxwsBinding == null) {
            jaxwsBinding = new JAXWSBinding(context.getLocation(e));
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "wsdlLocation")) != null) {
            jaxwsBinding.setWsdlLocation(attr);
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "node")) != null) {
            jaxwsBinding.setNode(attr);
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "version")) != null) {
            jaxwsBinding.setVersion(attr);
        }
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PACKAGE)) {
                this.parsePackage(context, jaxwsBinding, e2);
                if (jaxwsBinding.getJaxwsPackage() == null || jaxwsBinding.getJaxwsPackage().getJavaDoc() == null) continue;
                ((Definitions)parent).setDocumentation(new Documentation(jaxwsBinding.getJaxwsPackage().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                this.parseMimeContent(context, jaxwsBinding, e2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
            return false;
        }
        parent.addExtension(jaxwsBinding);
        context.pop();
        return true;
    }

    private static JAXWSBinding getJAXWSExtension(TWSDLExtensible extensible) {
        for (TWSDLExtension tWSDLExtension : extensible.extensions()) {
            if (!tWSDLExtension.getClass().equals(JAXWSBinding.class)) continue;
            return (JAXWSBinding)tWSDLExtension;
        }
        return null;
    }

    private void parseProvider(TWSDLParserContext context, JAXWSBinding parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            parent.setProvider(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            parent.setProvider(Boolean.TRUE);
        }
    }

    private void parsePackage(TWSDLParserContext context, JAXWSBinding parent, Element e) {
        String packageName = XmlUtil.getAttributeOrNull(e, "name");
        parent.setJaxwsPackage(new CustomName(packageName, this.getJavaDoc(e)));
    }

    private void parseWrapperStyle(TWSDLParserContext context, JAXWSBinding parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            parent.setEnableWrapperStyle(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            parent.setEnableWrapperStyle(Boolean.TRUE);
        }
    }

    private void parseAsynMapping(TWSDLParserContext context, JAXWSBinding parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            parent.setEnableAsyncMapping(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            parent.setEnableAsyncMapping(Boolean.TRUE);
        }
    }

    private void parseMimeContent(TWSDLParserContext context, JAXWSBinding parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            parent.setEnableMimeContentMapping(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            parent.setEnableMimeContentMapping(Boolean.TRUE);
        }
    }

    private void parseMethod(TWSDLParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String methodName = XmlUtil.getAttributeOrNull(e, "name");
        String javaDoc = this.getJavaDoc(e);
        CustomName name = new CustomName(methodName, javaDoc);
        jaxwsBinding.setMethodName(name);
    }

    private void parseParameter(TWSDLParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String part = XmlUtil.getAttributeOrNull(e, "part");
        Element msgPartElm = this.evaluateXPathNode(e.getOwnerDocument(), part, new NamespaceContextImpl(e));
        Node msgElm = msgPartElm.getParentNode();
        String partName = XmlUtil.getAttributeOrNull(msgPartElm, "name");
        String msgName = XmlUtil.getAttributeOrNull((Element)msgElm, "name");
        if (partName == null || msgName == null) {
            return;
        }
        String element = XmlUtil.getAttributeOrNull(e, "childElementName");
        String name = XmlUtil.getAttributeOrNull(e, "name");
        QName elementName = null;
        if (element != null) {
            String uri = e.lookupNamespaceURI(XmlUtil.getPrefix(element));
            elementName = uri == null ? null : new QName(uri, XmlUtil.getLocalPart(element));
        }
        jaxwsBinding.addParameter(new Parameter(msgName, partName, elementName, name));
    }

    private Element evaluateXPathNode(Node target, String expression, NamespaceContext namespaceContext) {
        NodeList nlst;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nlst = (NodeList)this.xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Util.fail("internalizer.XPathEvaluationError", e.getMessage());
            return null;
        }
        if (nlst.getLength() == 0) {
            Util.fail("internalizer.XPathEvaluatesToNoTarget", new Object[]{expression});
            return null;
        }
        if (nlst.getLength() != 1) {
            Util.fail("internalizer.XPathEvaulatesToTooManyTargets", new Object[]{expression, nlst.getLength()});
            return null;
        }
        Node rnode = nlst.item(0);
        if (!(rnode instanceof Element)) {
            Util.fail("internalizer.XPathEvaluatesToNonElement", new Object[]{expression});
            return null;
        }
        return (Element)rnode;
    }

    private void parseClass(TWSDLParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String className = XmlUtil.getAttributeOrNull(e, "name");
        String javaDoc = this.getJavaDoc(e);
        jaxwsBinding.setClassName(new CustomName(className, javaDoc));
    }

    @Override
    public boolean handleDefinitionsExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        return this.parseGlobalJAXWSBindings(context, parent, e);
    }

    @Override
    public boolean handlePortTypeExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                    this.parseWrapperStyle(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                    this.parseAsynMapping(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null || !(parent instanceof PortType)) continue;
                    ((PortType)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleOperationExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            if (parent instanceof Operation) {
                return this.handlePortTypeOperation(context, (Operation)parent, e);
            }
            if (parent instanceof BindingOperation) {
                return this.handleBindingOperation(context, (BindingOperation)parent, e);
            }
        } else {
            Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
            return false;
        }
        return false;
    }

    private boolean handleBindingOperation(TWSDLParserContext context, BindingOperation operation, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PARAMETER)) {
                    this.parseParameter(context, jaxwsBinding, e2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            operation.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    private boolean handlePortTypeOperation(TWSDLParserContext context, Operation parent, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.METHOD)) {
                this.parseMethod(context, jaxwsBinding, e2);
                if (jaxwsBinding.getMethodName() == null || jaxwsBinding.getMethodName().getJavaDoc() == null) continue;
                parent.setDocumentation(new Documentation(jaxwsBinding.getMethodName().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PARAMETER)) {
                this.parseParameter(context, jaxwsBinding, e2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
            return false;
        }
        parent.addExtension(jaxwsBinding);
        context.pop();
        return true;
    }

    @Override
    public boolean handleBindingExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(context, jaxwsBinding, e2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleFaultExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null) continue;
                    ((Fault)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleServiceExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null) continue;
                    ((Service)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PROVIDER)) {
                    this.parseProvider(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.METHOD)) {
                    this.parseMethod(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getMethodName() == null || jaxwsBinding.getMethodName().getJavaDoc() == null) continue;
                    ((Port)parent).setDocumentation(new Documentation(jaxwsBinding.getMethodName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    private String getJavaDoc(Element e) {
        Element e2;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (!XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.JAVADOC)) continue;
            return XmlUtil.getTextForNode(e2);
        }
        return null;
    }
}

