/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class AnnotationMemberImpl
implements AnnotationMember {
    final AnnotationMember.Kind kind;
    final Object value;
    final BeanManager bm;

    AnnotationMemberImpl(Object value, BeanManager bm) {
        this.kind = AnnotationMemberImpl.determineKind(value);
        this.value = value;
        this.bm = bm;
    }

    private static AnnotationMember.Kind determineKind(Object value) {
        if (value instanceof Boolean) {
            return AnnotationMember.Kind.BOOLEAN;
        }
        if (value instanceof Byte) {
            return AnnotationMember.Kind.BYTE;
        }
        if (value instanceof Short) {
            return AnnotationMember.Kind.SHORT;
        }
        if (value instanceof Integer) {
            return AnnotationMember.Kind.INT;
        }
        if (value instanceof Long) {
            return AnnotationMember.Kind.LONG;
        }
        if (value instanceof Float) {
            return AnnotationMember.Kind.FLOAT;
        }
        if (value instanceof Double) {
            return AnnotationMember.Kind.DOUBLE;
        }
        if (value instanceof Character) {
            return AnnotationMember.Kind.CHAR;
        }
        if (value instanceof String) {
            return AnnotationMember.Kind.STRING;
        }
        if (value instanceof Enum) {
            return AnnotationMember.Kind.ENUM;
        }
        if (value instanceof Class) {
            return AnnotationMember.Kind.CLASS;
        }
        if (value instanceof Annotation) {
            return AnnotationMember.Kind.NESTED_ANNOTATION;
        }
        if (value instanceof boolean[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof byte[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof short[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof int[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof long[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof float[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof double[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof char[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        if (value instanceof Object[]) {
            return AnnotationMember.Kind.ARRAY;
        }
        throw LiteExtensionTranslatorLogger.LOG.unknownAnnotationMember(value);
    }

    private void checkKind(AnnotationMember.Kind kind) {
        if (this.kind != kind) {
            throw LiteExtensionTranslatorLogger.LOG.kindNotEqual(kind, this.value);
        }
    }

    public AnnotationMember.Kind kind() {
        return this.kind;
    }

    public boolean asBoolean() {
        this.checkKind(AnnotationMember.Kind.BOOLEAN);
        return (Boolean)this.value;
    }

    public byte asByte() {
        this.checkKind(AnnotationMember.Kind.BYTE);
        return (Byte)this.value;
    }

    public short asShort() {
        this.checkKind(AnnotationMember.Kind.SHORT);
        return (Short)this.value;
    }

    public int asInt() {
        this.checkKind(AnnotationMember.Kind.INT);
        return (Integer)this.value;
    }

    public long asLong() {
        this.checkKind(AnnotationMember.Kind.LONG);
        return (Long)this.value;
    }

    public float asFloat() {
        this.checkKind(AnnotationMember.Kind.FLOAT);
        return ((Float)this.value).floatValue();
    }

    public double asDouble() {
        this.checkKind(AnnotationMember.Kind.DOUBLE);
        return (Double)this.value;
    }

    public char asChar() {
        this.checkKind(AnnotationMember.Kind.CHAR);
        return ((Character)this.value).charValue();
    }

    public String asString() {
        this.checkKind(AnnotationMember.Kind.STRING);
        return (String)this.value;
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType) {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return (E)((Enum)enumType.cast(this.value));
    }

    public String asEnumConstant() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return ((Enum)this.value).name();
    }

    public ClassInfo asEnumClass() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        Class enumType = ((Enum)this.value).getDeclaringClass();
        return new ClassInfoImpl(this.bm.createAnnotatedType(enumType), this.bm);
    }

    public Type asType() {
        this.checkKind(AnnotationMember.Kind.CLASS);
        Class clazz = (Class)this.value;
        return TypeImpl.fromReflectionType(AnnotatedTypes.from(clazz), this.bm);
    }

    public AnnotationInfo asNestedAnnotation() {
        this.checkKind(AnnotationMember.Kind.NESTED_ANNOTATION);
        return new AnnotationInfoImpl((Annotation)this.value, this.bm);
    }

    public List<AnnotationMember> asArray() {
        ArrayList<AnnotationMemberImpl> result;
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            this.checkKind(AnnotationMember.Kind.ARRAY);
                                            result = new ArrayList<AnnotationMemberImpl>();
                                            if (!(this.value instanceof boolean[])) break block9;
                                            for (boolean element : (boolean[])this.value) {
                                                result.add(new AnnotationMemberImpl(element, this.bm));
                                            }
                                            break block10;
                                        }
                                        if (!(this.value instanceof byte[])) break block11;
                                        for (byte element : (byte[])this.value) {
                                            result.add(new AnnotationMemberImpl(element, this.bm));
                                        }
                                        break block10;
                                    }
                                    if (!(this.value instanceof short[])) break block12;
                                    for (short element : (short[])this.value) {
                                        result.add(new AnnotationMemberImpl(element, this.bm));
                                    }
                                    break block10;
                                }
                                if (!(this.value instanceof int[])) break block13;
                                for (int element : (int[])this.value) {
                                    result.add(new AnnotationMemberImpl(element, this.bm));
                                }
                                break block10;
                            }
                            if (!(this.value instanceof long[])) break block14;
                            for (long element : (long[])this.value) {
                                result.add(new AnnotationMemberImpl(element, this.bm));
                            }
                            break block10;
                        }
                        if (!(this.value instanceof float[])) break block15;
                        for (float element : (float[])this.value) {
                            result.add(new AnnotationMemberImpl(Float.valueOf(element), this.bm));
                        }
                        break block10;
                    }
                    if (!(this.value instanceof double[])) break block16;
                    for (double element : (double[])this.value) {
                        result.add(new AnnotationMemberImpl(element, this.bm));
                    }
                    break block10;
                }
                if (!(this.value instanceof char[])) break block17;
                for (char element : (char[])this.value) {
                    result.add(new AnnotationMemberImpl(Character.valueOf(element), this.bm));
                }
                break block10;
            }
            if (!(this.value instanceof Object[])) break block10;
            for (Object element : (Object[])this.value) {
                result.add(new AnnotationMemberImpl(element, this.bm));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationMemberImpl that = (AnnotationMemberImpl)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

