/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class TransactionManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] txnIdParam;
    private static MBeanOperationInfo[] ops;

    public Integer getNumTransactions() {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        Vector transactions = tl.getTransactions(-1);
        return transactions.size();
    }

    public void commit(String transactionID) throws MBeanException {
        this.doRollbackCommit(transactionID, false);
    }

    public String[] getTransactionIDs() throws MBeanException {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        Vector transactions = tl.getTransactions(-1);
        if (transactions == null || transactions.size() == 0) {
            return null;
        }
        String[] ids = new String[transactions.size()];
        Enumeration e = transactions.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            TransactionUID tid = (TransactionUID)e.nextElement();
            long txnID = tid.longValue();
            try {
                String id;
                ids[i] = id = Long.toString(txnID);
            }
            catch (Exception ex) {
                this.handleOperationException("getTransactionIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public void rollback(String transactionID) throws MBeanException {
        this.doRollbackCommit(transactionID, true);
    }

    public void doRollbackCommit(String transactionID, boolean rollback) throws MBeanException {
        try {
            long longTid = 0L;
            if (transactionID == null) {
                throw new Exception("Null transaction ID");
            }
            try {
                longTid = Long.parseLong(transactionID);
            }
            catch (Exception e) {
                throw new Exception("Invalid transaction ID: " + transactionID);
            }
            TransactionUID tid = new TransactionUID(longTid);
            Globals.getDestinationList();
            TransactionList[] tls = DestinationList.getTransactionList(null);
            TransactionList tl = null;
            TransactionState ts = null;
            for (int i = 0; i < tls.length && ((tl = tls[i]) == null || (ts = tl.retrieveState(tid)) == null); ++i) {
            }
            if (ts == null) {
                throw new Exception(rb.getString("B3113", tid));
            }
            if (ts.getState() != 5) {
                throw new Exception(rb.getString("B3115", tid));
            }
            JMQXid xid = tl.UIDToXid(tid);
            if (xid == null) {
                throw new Exception(rb.getString("B3100", "Could not find Xid for " + String.valueOf(tid)));
            }
            PacketRouter pr = Globals.getPacketRouter(0);
            if (pr == null) {
                throw new Exception(rb.getString("B3100", "Could not locate Packet Router"));
            }
            TransactionHandler thandler = (TransactionHandler)pr.getHandler(48);
            if (thandler == null) {
                throw new Exception(rb.getString("B3100", "Could not locate Transaction Handler"));
            }
            if (rollback) {
                thandler.doRollback(tl, tid, xid, null, ts, null, null, RollbackReason.ADMIN);
            } else {
                thandler.doCommit(tl, tid, xid, 0, ts, null, false, null, null);
            }
        }
        catch (Exception e) {
            String opName = rollback ? "rollback" : "commit";
            this.handleOperationException(opName, e);
        }
    }

    @Override
    public String getMBeanName() {
        return "TransactionManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1153");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumTransactions", Integer.class.getName(), mbr.getString("MB1154"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("transactionID", String.class.getName(), mbr.getString("MB1162"));
        txnIdParam = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("commit", mbr.getString("MB1157"), txnIdParam, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getTransactionIDs", mbr.getString("MB1158"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("rollback", mbr.getString("MB1161"), txnIdParam, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
    }
}

