/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyService;
import java.io.IOException;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Map;

public class GrizzlyProtocolImpl
implements Protocol {
    protected static final int defaultReadTimeout = 0;
    protected static final int defaultLingerTimeout = 0;
    protected static final int defaultBacklog = 100;
    private static final int defaultPort = 8888;
    protected boolean requireClientAuth = false;
    protected GrizzlyService service = null;
    protected String proto = null;
    protected String modelName = null;
    protected int readTimeout = 0;
    protected int lingerTimeout = 0;
    protected int backlog = 100;
    protected boolean tcpNoDelay = true;
    protected int inputBufferSize = 0;
    protected int outputBufferSize = 0;
    protected int port = 8888;
    protected String hostname = null;
    protected int minThreads = 4;
    protected int maxThreads = 10;

    public GrizzlyProtocolImpl(GrizzlyService s, String proto) {
        this.service = s;
        this.proto = proto;
    }

    public String getType() {
        return this.proto;
    }

    @Override
    public void setNoDelay(boolean v) {
        this.tcpNoDelay = v;
    }

    public boolean getNoDelay() {
        return this.tcpNoDelay;
    }

    public int getLingerTimeout() {
        return this.lingerTimeout;
    }

    @Override
    public void setTimeout(int time) {
        this.readTimeout = time;
    }

    public int getTimeout() {
        return this.readTimeout;
    }

    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setInputBufferSize(int size) {
        this.inputBufferSize = size;
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.outputBufferSize = size;
    }

    @Override
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public boolean getBlocking() {
        throw new UnsupportedOperationException("Unsupported call: " + this.getClass().getName() + ".getBlocking");
    }

    public boolean getRequireClientAuth() {
        return this.requireClientAuth;
    }

    @Override
    public void registerProtocolCallback(ProtocolCallback cb, Object callback_data) {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".registerProtocolCallback()");
    }

    protected void notifyProtocolCallback() {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".notifyProtocolCallback()");
    }

    @Override
    public boolean canPause() {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".canPause()");
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        throw new UnsupportedOperationException("Unsupported call: " + this.getClass().getName() + ".configureBlocking");
    }

    @Override
    public AbstractSelectableChannel getChannel() throws IOException {
        return null;
    }

    @Override
    public ProtocolStreams accept() throws IOException {
        throw new UnsupportedOperationException("GrizzlyProtocolImpl:accept");
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return this.service.isOpen();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void checkParameters(Map params) {
        TcpProtocol.checkTcpParameters(params);
    }

    @Override
    public Map setParameters(Map params) throws IOException {
        boolean newhost;
        if (params.get("serviceFactoryHandlerName") != null) {
            this.modelName = (String)params.get("serviceFactoryHandlerName");
        }
        HashMap<String, String> oldparams = null;
        int newport = TcpProtocol.getIntValue("port", params, this.port);
        this.readTimeout = TcpProtocol.getIntValue("readtimeout", params, this.readTimeout);
        this.lingerTimeout = TcpProtocol.getIntValue("solinger", params, this.lingerTimeout);
        int newbacklog = TcpProtocol.getIntValue("backlog", params, this.backlog);
        String newhostname = (String)params.get("hostname");
        if (newhostname == null) {
            newhostname = Globals.getHostname();
        }
        if (newhostname == null || newhostname.trim().length() == 0) {
            newhostname = "*";
        }
        boolean bl = newhost = this.hostname == null || this.hostname != null && !newhostname.equals(this.hostname);
        if (newport != this.port || newbacklog != this.backlog || newhost) {
            oldparams = new HashMap<String, String>();
            if (newport != -1) {
                oldparams.put("port", String.valueOf(this.port));
                this.port = newport;
            }
            if (newbacklog != -1) {
                oldparams.put("backlog", String.valueOf(this.backlog));
                this.backlog = newbacklog;
            }
            if (newhost) {
                oldparams.put("hostname", this.hostname == null ? "" : this.hostname);
                this.hostname = newhostname;
            }
        }
        if (this.isSSLProtocol()) {
            this.requireClientAuth = TcpProtocol.getBooleanValue("requireClientAuth", params, this.requireClientAuth);
        }
        return oldparams;
    }

    protected boolean isSSLProtocol() {
        return this.proto.equals("tls");
    }

    @Override
    public int getLocalPort() {
        return this.service.getLocalPort();
    }

    @Override
    public String getHostName() {
        if (this.hostname == null || this.hostname.equals("") || this.hostname.equals("*")) {
            return null;
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int[] setMinMaxThreads(int min, int max, String svcname) {
        int[] rets = new int[2];
        rets[1] = -1;
        rets[0] = -1;
        int tmpmin = min;
        int tmpmax = max;
        tmpmin = tmpmin <= -1 ? this.minThreads : (int)((float)min / 2.0f);
        if ((tmpmax = tmpmax <= -1 ? this.maxThreads : (int)((float)max / 2.0f)) == 0) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getKString("B4136", svcname, String.valueOf(max)));
        }
        if (tmpmin > tmpmax) {
            Object[] args = new String[]{this.service.getName(), String.valueOf(tmpmin), String.valueOf(tmpmax)};
            String emsg = Globals.getBrokerResources().getKString("B2292", args);
            Globals.getLogger().log(16, emsg);
            tmpmin = tmpmax;
        }
        if (tmpmin != this.minThreads) {
            rets[0] = this.minThreads = tmpmin;
        }
        if (tmpmax != this.maxThreads) {
            rets[1] = this.maxThreads = tmpmax;
        }
        return rets;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public String toString() {
        return this.getType() + "(host = " + (this.hostname == null ? "*" : this.hostname) + ", port=" + this.port + ", mode=" + this.modelName + ")";
    }
}

