/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

final class FrameworkHelper {
    private FrameworkHelper() {
    }

    static boolean isVowel(char c) {
        return c == 'A' || c == 'a' || c == 'e' || c == 'E' || c == 'i' || c == 'I' || c == 'o' || c == 'O' || c == 'u' || c == 'U';
    }

    static String removeAllButAlphaNumericToFit(String s1, int maximumStringLength) {
        int s1Index;
        int s1Size = s1.length();
        if (s1Size <= maximumStringLength) {
            return s1;
        }
        StringBuilder buf = new StringBuilder();
        int numberOfCharsToBeRemoved = s1.length() - maximumStringLength;
        for (s1Index = 0; numberOfCharsToBeRemoved > 0 && s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (Character.isLetterOrDigit(currentChar)) {
                buf.append(currentChar);
                continue;
            }
            --numberOfCharsToBeRemoved;
        }
        while (s1Index < s1Size) {
            buf.append(s1.charAt(s1Index));
            ++s1Index;
        }
        return buf.toString();
    }

    static String shortenStringsByRemovingVowelsToFit(String s1, String s2, int maximumStringLength) {
        int size = s1.length() + s2.length();
        if (size <= maximumStringLength) {
            return s1 + s2;
        }
        int s1Size = s1.length();
        int s2Size = s2.length();
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int numberOfCharsToBeRemoved = size - maximumStringLength;
        int s1Index = 0;
        int s2Index = 0;
        int modulo2 = 0;
        while (numberOfCharsToBeRemoved > 0 && (s1Index < s1Size || s2Index < s2Size)) {
            if (modulo2 % 2 == 0) {
                if (s1Index < s1Size) {
                    if (FrameworkHelper.isVowel(s1.charAt(s1Index))) {
                        --numberOfCharsToBeRemoved;
                    } else {
                        buf1.append(s1.charAt(s1Index));
                    }
                    ++s1Index;
                }
            } else if (s2Index < s2Size) {
                if (FrameworkHelper.isVowel(s2.charAt(s2Index))) {
                    --numberOfCharsToBeRemoved;
                } else {
                    buf2.append(s2.charAt(s2Index));
                }
                ++s2Index;
            }
            ++modulo2;
        }
        while (s1Index < s1Size) {
            buf1.append(s1.charAt(s1Index));
            ++s1Index;
        }
        while (s2Index < s2Size) {
            buf2.append(s2.charAt(s2Index));
            ++s2Index;
        }
        return buf1.toString() + String.valueOf(buf2);
    }

    static String truncate(String originalString, int size) {
        if (originalString.length() <= size) {
            return originalString;
        }
        String vowels = "AaEeIiOoUu";
        StringBuilder newStringBufferTmp = new StringBuilder(originalString.length());
        int counter = originalString.length() - size;
        for (int index = originalString.length() - 1; index >= 0; --index) {
            if (vowels.indexOf(originalString.charAt(index)) == -1) {
                newStringBufferTmp.append(originalString.charAt(index));
                continue;
            }
            if (--counter != 0) continue;
            StringBuilder newStringBuffer = new StringBuilder(size);
            newStringBuffer.append(originalString.substring(0, index));
            newStringBuffer.append((CharSequence)newStringBufferTmp.reverse());
            return newStringBuffer.toString();
        }
        return newStringBufferTmp.reverse().substring(0, size);
    }

    static String removeVowels(String s1) {
        StringBuilder buf = new StringBuilder();
        int s1Size = s1.length();
        for (int s1Index = 0; s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (FrameworkHelper.isVowel(currentChar)) continue;
            buf.append(currentChar);
        }
        return buf.toString();
    }
}

