/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class InjectionManagerImpl
implements InjectionManager,
PostConstruct {
    private static final System.Logger LOG = System.getLogger(InjectionManagerImpl.class.getName());
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private GlassfishNamingManager glassfishNamingManager;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ProcessEnvironment processEnvironment;

    public void postConstruct() {
        if (this.processEnvironment.getProcessType().isServer()) {
            try {
                this.glassfishNamingManager.publishObject(new SimpleJndiName(InjectionManager.class.getName()), (Object)this, true);
            }
            catch (NamingException ne) {
                throw new RuntimeException(ne);
            }
        }
    }

    @Override
    public void injectInstance(Object instance) throws InjectionException {
        this.injectInstance(instance, true);
    }

    @Override
    public void injectInstance(Object instance, boolean invokePostConstruct) throws InjectionException {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new InjectionException("Null invocation context");
        }
        JndiNameEnvironment componentEnv = this.componentEnvManager.getJndiNameEnvironment(currentInvocation.getComponentId());
        if (componentEnv == null) {
            throw new InjectionException("No descriptor registered for current invocation: " + String.valueOf(currentInvocation));
        }
        this.inject(instance.getClass(), instance, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, null, true);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void injectInstance(Object instance, SimpleJndiName jndiName, boolean invokePostConstruct) throws InjectionException {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new InjectionException("Null invocation context");
        }
        String componentId = jndiName == null ? null : jndiName.toString();
        JndiNameEnvironment componentEnv = this.componentEnvManager.getJndiNameEnvironment(componentId);
        if (componentEnv == null) {
            throw new InjectionException("No descriptor registered for componentId: " + String.valueOf(jndiName));
        }
        this.inject(instance.getClass(), instance, componentEnv, componentId, invokePostConstruct);
    }

    @Override
    public void injectClass(Class<?> clazz, SimpleJndiName jndiName, boolean invokePostConstruct) throws InjectionException {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new InjectionException("Null invocation context");
        }
        String componentId = jndiName == null ? null : jndiName.toString();
        JndiNameEnvironment componentEnv = this.componentEnvManager.getJndiNameEnvironment(componentId);
        if (componentEnv == null) {
            throw new InjectionException("No descriptor registered for jndiName: " + String.valueOf(jndiName));
        }
        this.injectClass(clazz, componentEnv, invokePostConstruct);
    }

    @Override
    public void injectClass(Class<?> clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.injectClass(clazz, componentEnv, true);
    }

    @Override
    public void injectClass(Class<?> clazz, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(clazz, null, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeInstancePostConstruct(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePostConstruct(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance) throws InjectionException {
        this.invokeInstancePreDestroy(instance, true);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance, boolean validate) throws InjectionException {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        LOG.log(System.Logger.Level.DEBUG, "invokeInstancePreDestroy(instance={0}, validate={1}); invocation={2}", instance, validate, currentInvocation);
        if (currentInvocation == null) {
            if (validate) {
                throw new InjectionException("Null invocation context");
            }
            return;
        }
        String componentId = currentInvocation.getComponentId();
        JndiNameEnvironment componentEnv = this.componentEnvManager.getJndiNameEnvironment(componentId);
        if (componentEnv == null) {
            if (validate) {
                throw new InjectionException("No descriptor registered for current invocation: " + String.valueOf(currentInvocation));
            }
            return;
        }
        this.invokePreDestroy(instance.getClass(), instance, componentEnv);
    }

    public void invokeClassPreDestroy(Class clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(clazz, null, componentEnv);
    }

    @Override
    public <T> T createManagedObject(Class<T> clazz) throws InjectionException {
        LOG.log(System.Logger.Level.DEBUG, "createManagedObject(clazz={0})", clazz);
        T managedObject = null;
        try {
            ManagedBeanManager managedBeanManager = (ManagedBeanManager)this.serviceLocator.getService(ManagedBeanManager.class, new Annotation[0]);
            CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
            if (cdiService != null && cdiService.isCurrentModuleCDIEnabled()) {
                managedObject = managedBeanManager.createManagedBean(clazz);
            } else {
                managedObject = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.injectInstance(managedObject);
            }
        }
        catch (Exception e) {
            throw new InjectionException("Error creating managed object for class: " + String.valueOf(clazz), e);
        }
        return managedObject;
    }

    @Override
    public <T> T createManagedObject(Class<T> clazz, boolean invokePostConstruct) throws InjectionException {
        LOG.log(System.Logger.Level.DEBUG, "createManagedObject(clazz={0}, invokePostConstruct={1})", clazz, invokePostConstruct);
        T managedObject = null;
        try {
            ManagedBeanManager managedBeanMgr = (ManagedBeanManager)this.serviceLocator.getService(ManagedBeanManager.class, new Annotation[0]);
            CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
            if (cdiService != null && cdiService.isCurrentModuleCDIEnabled()) {
                managedObject = managedBeanMgr.createManagedBean(clazz, invokePostConstruct);
            } else {
                managedObject = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.injectInstance(managedObject, invokePostConstruct);
            }
        }
        catch (Exception e) {
            throw new InjectionException("Error creating managed object for class: " + String.valueOf(clazz), e);
        }
        return managedObject;
    }

    @Override
    public void destroyManagedObject(Object managedObject) throws InjectionException {
        this.destroyManagedObject(managedObject, true);
    }

    @Override
    public void destroyManagedObject(Object managedObject, boolean validate) throws InjectionException {
        LOG.log(System.Logger.Level.DEBUG, "destroyManagedObject(managedObject={0}, validate={1})", managedObject, validate);
        ManagedBeanManager managedBeanManager = (ManagedBeanManager)this.serviceLocator.getService(ManagedBeanManager.class, new Annotation[0]);
        CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
        if (cdiService != null && cdiService.isCurrentModuleCDIEnabled()) {
            managedBeanManager.destroyManagedBean(managedObject, validate);
        } else if (managedBeanManager.isManagedBean(managedObject)) {
            managedBeanManager.destroyManagedBean(managedObject, validate);
        } else {
            this.invokeInstancePreDestroy(managedObject, validate);
        }
    }

    @Override
    public <T> void inject(Class<? extends T> clazz, T instance, JndiNameEnvironment envDescriptor, String componentId, boolean invokePostConstruct) throws InjectionException {
        LOG.log(System.Logger.Level.DEBUG, "inject(clazz={0}, instance={1}, envDescriptor, componentId={2}, invokePostConstruct={3})", clazz, instance, componentId, invokePostConstruct);
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class<T> nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (!injInfo.getInjectionResources().isEmpty()) {
                this._inject(nextClass, instance, componentId, injInfo.getInjectionResources());
            }
            if (!invokePostConstruct || injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private void invokePreDestroy(Class<?> clazz, Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LOG.log(System.Logger.Level.TRACE, "invokePreDestroy(clazz={0}, instance, envDescriptor.class={1})", clazz, envDescriptor.getClass());
        LinkedList<Method> preDestroyMethods = new LinkedList<Method>();
        for (Class<?> nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getPreDestroyMethodName() == null) continue;
            Method preDestroyMethod = this.getPreDestroyMethod(injInfo, nextClass);
            preDestroyMethods.addFirst(preDestroyMethod);
        }
        for (Method preDestroyMethod : preDestroyMethods) {
            this.invokeLifecycleMethod(preDestroyMethod, instance);
        }
    }

    private void invokePostConstruct(Class<?> clazz, Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class<?> nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private void _inject(Class<?> clazz, Object instance, String componentId, List<InjectionCapable> injectableResources) throws InjectionException {
        LOG.log(System.Logger.Level.TRACE, "_inject(clazz={0}, instance={1}, componentId={2}, injectableResources.size={0})", clazz, instance, componentId, injectableResources.size());
        for (InjectionCapable next : injectableResources) {
            try {
                SimpleJndiName lookupName = next.getComponentEnvName();
                if (!lookupName.hasJavaPrefix()) {
                    lookupName = new SimpleJndiName("java:comp/env/" + String.valueOf(lookupName));
                }
                Object value = componentId == null ? this.glassfishNamingManager.lookup(lookupName) : this.glassfishNamingManager.lookup(componentId, lookupName);
                for (InjectionTarget target : next.getInjectionTargets()) {
                    if (!clazz.getName().equals(target.getClassName())) continue;
                    if (target.isFieldInjectable()) {
                        Field injectableField = this.getField(target, clazz);
                        if (Modifier.isStatic(injectableField.getModifiers()) && instance != null) {
                            throw new InjectionException("Illegal use of static field on class that only supports instance-based injection: " + String.valueOf(injectableField));
                        }
                        if (instance == null && !Modifier.isStatic(injectableField.getModifiers())) {
                            throw new InjectionException(MessageFormat.format("Injected field: {0} on Application Client class: {1} must be declared static", injectableField, clazz));
                        }
                        LOG.log(System.Logger.Level.DEBUG, "Injecting dependency with logical name: {0} into field: {1} on class: {2}", next.getComponentEnvName(), injectableField, clazz);
                        injectableField.set(instance, value);
                        continue;
                    }
                    if (!target.isMethodInjectable()) continue;
                    Method method = this.getMethod(next, target, clazz);
                    if (Modifier.isStatic(method.getModifiers()) && instance != null) {
                        throw new InjectionException("Illegal use of static method on class that only supports instance-based injection: " + String.valueOf(method));
                    }
                    if (instance == null && !Modifier.isStatic(method.getModifiers())) {
                        throw new InjectionException(MessageFormat.format("Injected method: {0} on Application Client class: {1} must be declared static", method, clazz));
                    }
                    LOG.log(System.Logger.Level.DEBUG, "Injecting dependency with logical name: {0} into method: {1} on class: {2}", next.getComponentEnvName(), method, clazz);
                    method.invoke(instance, value);
                }
            }
            catch (Throwable t) {
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                String msg = MessageFormat.format("Exception attempting to inject {0} into {1}: {2}", next, clazz, cause.getMessage());
                throw new InjectionException(msg, cause);
            }
        }
    }

    private void invokeLifecycleMethod(Method lifecycleMethod, Object instance) throws InjectionException {
        LOG.log(System.Logger.Level.DEBUG, "Calling lifecycle method: {0} on class: {1}", lifecycleMethod, lifecycleMethod.getDeclaringClass());
        try {
            if (!lifecycleMethod.trySetAccessible()) {
                throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(lifecycleMethod));
            }
            lifecycleMethod.invoke(instance, new Object[0]);
        }
        catch (Throwable t) {
            InjectionException ie = new InjectionException("Exception attempting invoke lifecycle method: " + String.valueOf(lifecycleMethod));
            Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }

    private Field getField(InjectionTarget target, Class<?> resourceClass) throws Exception {
        Field targetField = target.getField();
        if (targetField == null) {
            try {
                targetField = resourceClass.getDeclaredField(target.getFieldName());
                if (!targetField.trySetAccessible()) {
                    throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(targetField));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (targetField != null) {
                target.setField(targetField);
            }
        }
        if (targetField == null) {
            throw new Exception(MessageFormat.format("InjectionManager exception.  Field: {0} not found in class: {1}", target.getFieldName(), resourceClass));
        }
        return targetField;
    }

    private Method getMethod(InjectionCapable resource, InjectionTarget target, Class<?> resourceClass) throws Exception {
        Method targetMethod = target.getMethod();
        if (targetMethod == null) {
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(target.getMethodName())) continue;
                targetMethod = next;
                target.setMethod(targetMethod);
                if (targetMethod.trySetAccessible()) break;
                throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(targetMethod));
            }
        }
        if (targetMethod == null) {
            throw new Exception(MessageFormat.format("InjectionManager exception.  Method: void {0} ({1}) not found in class: {2}", target.getMethodName(), resource.getInjectResourceType(), resourceClass));
        }
        return targetMethod;
    }

    private Method getPostConstructMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method m = injInfo.getPostConstructMethod();
        if (m == null) {
            String postConstructMethodName = injInfo.getPostConstructMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(postConstructMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPostConstructMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException(MessageFormat.format("InjectionManager exception. PostConstruct method: {0} not found in class: {1}", injInfo.getPostConstructMethodName(), injInfo.getClassName()));
        }
        return m;
    }

    private Method getPreDestroyMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method preDestroyMethod = injInfo.getPreDestroyMethod();
        if (preDestroyMethod == null) {
            String preDestroyMethodName = injInfo.getPreDestroyMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(preDestroyMethodName) || next.getParameterTypes().length != 0) continue;
                preDestroyMethod = next;
                injInfo.setPreDestroyMethod(preDestroyMethod);
                break;
            }
        }
        if (preDestroyMethod == null) {
            throw new InjectionException(MessageFormat.format("InjectionManager exception. PreDestroy method: {0} not found in class: {1}", injInfo.getPreDestroyMethodName(), injInfo.getClassName()));
        }
        return preDestroyMethod;
    }
}

