/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.reflect.Type;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.properties.Constrainable;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.TypeHelper;

class BeanConstraintLocation
implements ConstraintLocation {
    private final Class<?> declaringClass;
    private final Type typeForValidatorResolution;

    BeanConstraintLocation(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
        this.typeForValidatorResolution = declaringClass.getTypeParameters().length == 0 ? declaringClass : TypeHelper.parameterizedType(declaringClass, declaringClass.getTypeParameters());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Constrainable getConstrainable() {
        return null;
    }

    @Override
    public Type getTypeForValidatorResolution() {
        return this.typeForValidatorResolution;
    }

    @Override
    public void appendTo(ExecutableParameterNameProvider parameterNameProvider, MutablePath path) {
        path.addBeanNode();
    }

    @Override
    public void applyTo(ExecutableParameterNameProvider parameterNameProvider, MutablePath path) {
        path.getLeafNode().resetAsBeanNode();
    }

    @Override
    public Object getValue(Object parent) {
        return parent;
    }

    @Override
    public ConstraintLocation.ConstraintLocationKind getKind() {
        return ConstraintLocation.ConstraintLocationKind.TYPE;
    }

    public String toString() {
        return "BeanConstraintLocation [declaringClass=" + String.valueOf(this.declaringClass) + ", typeForValidatorResolution=" + String.valueOf(this.typeForValidatorResolution) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.typeForValidatorResolution == null ? 0 : this.typeForValidatorResolution.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanConstraintLocation other = (BeanConstraintLocation)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return !(this.typeForValidatorResolution == null ? other.typeForValidatorResolution != null : !this.typeForValidatorResolution.equals(other.typeForValidatorResolution));
    }
}

