/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.model.SelectItem;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public class OptionsHandlers {
    private static final Class SUN_OPTION_CLASS = Util.noExceptionLoadClass("com.sun.webui.jsf.model.Option");
    private static final Constructor SUN_OPTION_CONSTRUCTOR = OptionsHandlers.noExceptionFindConstructor(SUN_OPTION_CLASS, new Class[]{Object.class, String.class});

    public static void getSunOptions(HandlerContext context) throws Exception {
        Collection labels = (Collection)context.getInputValue("labels");
        Collection values = (Collection)context.getInputValue("values");
        if (labels.size() != values.size()) {
            throw new Exception("getSunOptions Handler input incorrect: Input 'labels' and 'values' size must be equal. 'labels' size: " + labels.size() + " 'values' size: " + values.size());
        }
        SelectItem[] options = (SelectItem[])Array.newInstance(SUN_OPTION_CLASS, labels.size());
        String[] labelsArray = labels.toArray(new String[labels.size()]);
        String[] valuesArray = values.toArray(new String[values.size()]);
        for (int i = 0; i < labels.size(); ++i) {
            SelectItem option;
            options[i] = option = OptionsHandlers.getSunOption(valuesArray[i], labelsArray[i]);
        }
        context.setOutputValue("options", options);
    }

    private static SelectItem getSunOption(String value, String label) {
        try {
            return (SelectItem)SUN_OPTION_CONSTRUCTOR.newInstance(value, label);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate '" + String.valueOf(SUN_OPTION_CLASS) + "'!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to instantiate '" + String.valueOf(SUN_OPTION_CLASS) + "'!", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Unable to instantiate '" + String.valueOf(SUN_OPTION_CLASS) + "'!", ex);
        }
    }

    private static Constructor noExceptionFindConstructor(Class cls, Class[] args) {
        Constructor constructor = null;
        try {
            constructor = cls.getConstructor(args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return constructor;
    }
}

