/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import jakarta.enterprise.inject.spi.SessionBeanType;
import java.lang.reflect.Type;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.events.AbstractProcessClassBean;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ProcessSessionBeanImpl<X>
extends AbstractProcessClassBean<Object, SessionBean<Object>>
implements ProcessSessionBean<X> {
    protected static <X> void fire(BeanManagerImpl beanManager, SessionBean<Object> bean) {
        if (beanManager.isBeanEnabled(bean)) {
            new ProcessSessionBeanImpl<X>(beanManager, (SessionBean)bean){}.fire();
        }
    }

    private ProcessSessionBeanImpl(BeanManagerImpl beanManager, SessionBean<Object> bean) {
        super(beanManager, (Type)((Object)ProcessSessionBean.class), new Type[]{bean.getAnnotated().getBaseType()}, bean);
    }

    public String getEjbName() {
        this.checkWithinObserverNotification();
        return ((SessionBean)this.getBean()).getEjbDescriptor().getEjbName();
    }

    public SessionBeanType getSessionBeanType() {
        this.checkWithinObserverNotification();
        if (((SessionBean)this.getBean()).getEjbDescriptor().isStateless()) {
            return SessionBeanType.STATELESS;
        }
        if (((SessionBean)this.getBean()).getEjbDescriptor().isStateful()) {
            return SessionBeanType.STATEFUL;
        }
        if (((SessionBean)this.getBean()).getEjbDescriptor().isSingleton()) {
            return SessionBeanType.SINGLETON;
        }
        throw BootstrapLogger.LOG.beanTypeNotEjb(this.getBean());
    }

    public AnnotatedType<Object> getAnnotatedBeanClass() {
        this.checkWithinObserverNotification();
        return ((SessionBean)this.getBean()).getAnnotated();
    }
}

