/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.external.amx.BootAMXMBean;

class BootAMXListener
implements NotificationListener {
    private static final Logger LOG = Util.JMX_LOGGER;
    private JMXConnectorServer mServer;
    private final BootAMXMBean mBooter;

    BootAMXListener(BootAMXMBean booter) {
        this.mBooter = booter;
    }

    void setServer(JMXConnectorServer server) {
        this.mServer = server;
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        JMXConnectionNotification n;
        if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
            LOG.log(Level.INFO, "Booting AMX Listener, connection made for {0}, now booting AMX MBeans", handback);
            this.mBooter.bootAMX();
            if (this.mServer != null) {
                try {
                    this.mServer.removeNotificationListener(this);
                    LOG.fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
                }
                catch (ListenerNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

