/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.glassfish.shoal.ha.cache.api.DataStoreContext;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.group.GroupService;

public final class TransmitInterceptor<K, V>
extends AbstractCommandInterceptor<K, V> {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.interceptor.transmit");

    @Override
    public void onTransmit(Command<K, V> cmd, String initiator) throws DataStoreException {
        DataStoreContext ctx = this.getDataStoreContext();
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        boolean transmitted = false;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(cmd);
            oos.close();
            byte[] data = bos.toByteArray();
            GroupService gs = ctx.getGroupService();
            gs.sendMessage(cmd.getTargetName(), ctx.getServiceName(), data);
            this.dsc.getDataStoreMBean().incrementGmsSendCount();
            this.dsc.getDataStoreMBean().incrementGmsSendBytesCount(data.length);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.storeName + ": TransmitInterceptor." + ctx.getServiceName() + ":onTransmit() Sent " + String.valueOf(cmd) + " to " + (cmd.getTargetName() == null ? " ALL MEMBERS " : cmd.getTargetName()) + "; size: " + data.length);
            }
            cmd.onSuccess();
            transmitted = true;
        }
        catch (IOException ioEx) {
            throw new DataStoreException("Error DURING transmit...", ioEx);
        }
        finally {
            if (!transmitted) {
                cmd.onFailure();
            }
            try {
                oos.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ObjectOutputStream");
            }
            try {
                bos.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ByteArrayOutputStream");
            }
        }
    }
}

