/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

public interface IJPQLQueryFormatter {
    public String toString(StateObject var1);

    public static enum IdentifierStyle {
        CAPITALIZE_EACH_WORD,
        LOWERCASE,
        UPPERCASE;


        public String capitalizeEachWord(String identifier) {
            StringBuilder sb = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(identifier, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                sb.append(Character.toUpperCase(token.charAt(0)));
                sb.append(token.substring(1).toLowerCase(Locale.ROOT));
                if (!tokenizer.hasMoreTokens()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }

        public String formatIdentifier(String identifier) {
            return switch (this.ordinal()) {
                case 0 -> this.capitalizeEachWord(identifier);
                case 1 -> identifier.toLowerCase(Locale.ROOT);
                default -> identifier.toUpperCase(Locale.ROOT);
            };
        }
    }
}

