/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.util;

import java.time.Duration;
import java.time.Instant;
import org.glassfish.api.admin.CommandException;

@FunctionalInterface
public interface CommandAction {
    public void action() throws CommandException;

    public static Duration step(String message, Duration timeout, CommandAction action) throws CommandException {
        if (timeout != null && timeout.isNegative()) {
            return timeout;
        }
        if (message != null) {
            System.out.print(message);
        }
        Instant start = Instant.now();
        action.action();
        Duration stopDuration = Duration.between(start, Instant.now());
        if (message != null) {
            System.out.println(" ... finished after " + stopDuration.toMillis() + " ms.");
        }
        return timeout == null ? null : timeout.minus(stopDuration);
    }
}

