/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.shoal.ha.cache.api.DataStore;
import org.glassfish.shoal.ha.cache.api.DataStoreContext;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.api.DataStoreFactory;
import org.glassfish.shoal.ha.cache.store.ReplicatedDataStore;
import org.glassfish.shoal.ha.cache.store.backing.ReplicatedBackingStoreFactory;

public class ReplicatedBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.store.backing");
    private String storeName = "";
    private DataStore<K, V> dataStore;
    private ReplicatedBackingStoreFactory factory;
    private long defaultMaxIdleTimeInMillis;

    void setBackingStoreFactory(ReplicatedBackingStoreFactory factory) {
        this.factory = factory;
    }

    public BackingStoreFactory getBackingStoreFactory() {
        return this.factory;
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dataStore == null ? null : ((ReplicatedDataStore)this.dataStore).getDataStoreContext();
    }

    public void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        super.initialize(conf);
        DataStoreContext dsConf = new DataStoreContext(conf);
        this.dataStore = DataStoreFactory.createDataStore(dsConf);
        this.storeName = dsConf.getStoreName();
    }

    public V load(K key, String versionInfo) throws BackingStoreException {
        try {
            return (V)((Serializable)this.dataStore.get(key));
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + String.valueOf(key), (Throwable)dsEx);
        }
    }

    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        try {
            return this.dataStore.put(key, value);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during save: " + String.valueOf(key), (Throwable)dsEx);
        }
    }

    public void remove(K key) throws BackingStoreException {
        try {
            if (this.dataStore != null) {
                this.dataStore.remove(key);
            }
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during remove: " + String.valueOf(key), (Throwable)dsEx);
        }
    }

    public int removeExpired(long idleTime) throws BackingStoreException {
        return this.dataStore.removeIdleEntries(idleTime);
    }

    public int size() throws BackingStoreException {
        return this.dataStore.size();
    }

    public void close() throws BackingStoreException {
        this.destroy();
    }

    public void destroy() throws BackingStoreException {
        if (this.dataStore != null) {
            this.dataStore.close();
            _logger.log(Level.FINE, "** StoreName = " + this.storeName + " is destroyed ");
        } else {
            _logger.log(Level.FINE, "** StoreName = " + this.storeName + " is already destroyed ");
        }
        this.dataStore = null;
        this.factory = null;
    }

    public void updateTimestamp(K key, long time) throws BackingStoreException {
        try {
            this.dataStore.touch(key, 0x7FFFFFFFFFFFFFFEL, time, this.defaultMaxIdleTimeInMillis);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during updateTimestamp: " + String.valueOf(key), (Throwable)dsEx);
        }
    }
}

