/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class JarFileEntry
extends ClasspathEntry {
    private JarFile jarfile;
    private BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);

    public JarFileEntry(ClasspathEntry previous, String jarfile) throws IOException {
        super(previous);
        this.init(jarfile);
    }

    @Override
    public void init(String jarfile) throws IOException {
        this.jarfile = new JarFile(jarfile);
        Enumeration<JarEntry> entries = this.jarfile.entries();
        this.classes = new LinkedHashSet();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.endsWith(".class")) continue;
            name = name.substring(0, name.length() - JAVA_CLASSFILE_EXTENSION_LEN).replace('/', '.');
            if (this.previousEntry != null && this.previousEntry.contains(name)) continue;
            this.classes.add(name.intern());
        }
        this.currentPosition = this.classes.iterator();
    }

    @Override
    public void close() {
        if (this.jarfile != null) {
            block3: {
                try {
                    this.jarfile.close();
                }
                catch (IOException e) {
                    if (!this.bo.isSet(Option.DEBUG)) break block3;
                    SwissKnife.reportThrowable(e);
                }
            }
            this.jarfile = null;
            this.classes = null;
        }
    }

    @Override
    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        JarEntry jarEntry = this.jarfile.getJarEntry((name = ExoticCharTools.decodeExotic(name)).replace('.', '/') + ".class");
        if (jarEntry == null) {
            throw new ClassNotFoundException(name);
        }
        return this.jarfile.getInputStream(jarEntry);
    }
}

