/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

public class PrimitiveTypes {
    private static Pair[] types = new Pair[]{new Pair('Z', "boolean"), new Pair('V', "void"), new Pair('I', "int"), new Pair('J', "long"), new Pair('C', "char"), new Pair('B', "byte"), new Pair('D', "double"), new Pair('S', "short"), new Pair('F', "float")};

    private PrimitiveTypes() {
    }

    public static boolean isPrimitive(String jlsType) {
        for (int i = 0; i < types.length; ++i) {
            if (!PrimitiveTypes.types[i].JLSNotation.equals(jlsType)) continue;
            return true;
        }
        return false;
    }

    public static String getPrimitiveType(char vmType) {
        for (int i = 0; i < types.length; ++i) {
            if (vmType != PrimitiveTypes.types[i].VMNotation) continue;
            return PrimitiveTypes.types[i].JLSNotation;
        }
        return null;
    }

    public static String getVMPrimitiveType(String jlsType) {
        for (int i = 0; i < types.length; ++i) {
            if (!PrimitiveTypes.types[i].JLSNotation.equals(jlsType)) continue;
            return String.valueOf(PrimitiveTypes.types[i].VMNotation);
        }
        return null;
    }

    public static String simpleObjectToString(Object o) {
        StringBuffer sb = new StringBuffer();
        PrimitiveTypes.simpleObjectToString(o, sb);
        return sb.toString().trim();
    }

    private static void simpleObjectToString(Object o, StringBuffer sb) {
        if (o.getClass().isArray()) {
            Object[] arr;
            sb.append("[");
            for (Object oo : arr = (Object[])o) {
                PrimitiveTypes.simpleObjectToString(oo, sb);
                sb.append(',');
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
        } else if (o instanceof String) {
            sb.append('\"');
            sb.append(o);
            sb.append('\"');
        } else if (o instanceof Class) {
            sb.append(((Class)o).getName());
        } else {
            sb.append(o.toString());
        }
    }

    public static Object stringToSimpleObject(String defValueAsString) {
        if (defValueAsString.equals("true")) {
            return Boolean.TRUE;
        }
        if (defValueAsString.equals("false")) {
            return Boolean.FALSE;
        }
        if (defValueAsString.endsWith("\"\"")) {
            return "";
        }
        if (defValueAsString.startsWith("\"") && defValueAsString.endsWith("\"")) {
            return defValueAsString.substring(1, defValueAsString.length() - 1);
        }
        return defValueAsString;
    }

    private static class Pair {
        char VMNotation;
        String JLSNotation;

        Pair(char vm, String jls) {
            this.VMNotation = vm;
            this.JLSNotation = jls;
        }
    }
}

