/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.whitebox.TSConnectionRequestInfo;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;

public class Util {
    public static PasswordCredential getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (subject == null) {
            if (info == null) {
                return null;
            }
            TSConnectionRequestInfo myinfo = (TSConnectionRequestInfo)info;
            PasswordCredential pc = new PasswordCredential(myinfo.getUser(), myinfo.getPassword().toCharArray());
            pc.setManagedConnectionFactory(mcf);
            return pc;
        }
        PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential temp : creds) {
                    if (!temp.getManagedConnectionFactory().equals((Object)mcf)) continue;
                    return temp;
                }
                return null;
            }
        });
        if (pc == null) {
            throw new SecurityException("No PasswordCredential found");
        }
        return pc;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (!Util.isEqual(a.getUserName(), b.getUserName())) {
            return false;
        }
        String p1 = null;
        String p2 = null;
        if (a.getPassword() != null) {
            p1 = new String(a.getPassword());
        }
        if (b.getPassword() != null) {
            p2 = new String(b.getPassword());
        }
        return Util.isEqual(p1, p2);
    }
}

