/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.dateformat;

import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.AnnotatedAccessorsDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.AnnotatedFieldDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.AnnotatedTypeDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.AnnotatedTypeFieldOverrideDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.DateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.customized.CustomizedPackageDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.customized.CustomizedPackageTypeOverrideDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.dateformat.model.customized.CustomizedPackageTypeOverrideFieldOverrideDateContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.annotation.JsonbDateFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateFormatCustomizationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testDateFormatConfig() {
        String format = "E DD MMM yyyy HH:mm:ss z";
        Locale locale = Locale.GERMAN;
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat(format, locale));
        final Date instance = new Date(0L);
        String jsonString = jsonb.toJson((Object)new DateContainer(){
            {
                this.setInstance(instance);
            }
        });
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format, locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbConfig.withDateFormat.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        DateContainer unmarshalledObject = (DateContainer)jsonb.fromJson(json, DateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbConfig.withDateFormat.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatPackage() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnPackage(CustomizedPackageDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on package.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        CustomizedPackageDateContainer unmarshalledObject = (CustomizedPackageDateContainer)this.jsonb.fromJson(json, CustomizedPackageDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on package.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatType() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedTypeDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(AnnotatedTypeDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedTypeDateContainer unmarshalledObject = (AnnotatedTypeDateContainer)this.jsonb.fromJson(json, AnnotatedTypeDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatField() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedFieldDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(AnnotatedFieldDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedFieldDateContainer unmarshalledObject = (AnnotatedFieldDateContainer)this.jsonb.fromJson(json, AnnotatedFieldDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on field.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatAccessors() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedAccessorsDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnMethod(AnnotatedAccessorsDateContainer.class, JsonbDateFormat.class, "getInstance", new Class[0]);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedAccessorsDateContainer unmarshalledObject = (AnnotatedAccessorsDateContainer)this.jsonb.fromJson(json, AnnotatedAccessorsDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on setter.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatConfigPackageOverride() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.GERMAN));
        final Date instance = new Date(0L);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnPackage(CustomizedPackageDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat during marshalling by annotating package with JsonbDateFormat.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        CustomizedPackageDateContainer unmarshalledObject = (CustomizedPackageDateContainer)jsonb.fromJson(json, CustomizedPackageDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat during unmarshalling by annotating package with JsonbDateFormat.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatPackageTypeOverride() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageTypeOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(CustomizedPackageTypeOverrideDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbDateFormat annotation on package during marshalling using JsonbDateFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideDateContainer)this.jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbDateFormat annotation on package during unmarshalling using JsonbDateFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatTypeFieldOverride() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedTypeFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(AnnotatedTypeFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        AnnotatedTypeFieldOverrideDateContainer unmarshalledObject = (AnnotatedTypeFieldOverrideDateContainer)this.jsonb.fromJson(json, AnnotatedTypeFieldOverrideDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatConfigPackageOverrideTypeOverride() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.CANADA));
        final Date instance = new Date(0L);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageTypeOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(CustomizedPackageTypeOverrideDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat and package annotating with JsonbDateFormat during marshalling by annotating type with JsonbDateFormat.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideDateContainer)jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat and package annotating with JsonbDateFormat during unmarshalling by annotating type with JsonbDateFormat.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatPackageTypeOverrideFieldOverride() {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageTypeOverrideFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(CustomizedPackageTypeOverrideFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbDateFormat annotation on package and type during marshalling using JsonbDateFormat annotation on field.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideFieldOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideFieldOverrideDateContainer)this.jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideFieldOverrideDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbDateFormat annotation on package and type during unmarshalling using JsonbDateFormat annotation on field.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDateFormatConfigPackageOverrideTypeOverrideFieldOverride() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.GERMAN));
        final Date instance = new Date(0L);
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(CustomizedPackageTypeOverrideFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageTypeOverrideFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat and package and type annotating with JsonbDateFormat during marshalling by annotating field with JsonbDateFormat.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)toMatch));
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideFieldOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideFieldOverrideDateContainer)jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideFieldOverrideDateContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override date format customization using JsonbConfig.withDateFormat and package and type annotating with JsonbDateFormat during unmarshalling by annotating field with JsonbDateFormat.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    private String completeByFormat(String prefix, String suffix, String mask, Locale locale, Date value) {
        return prefix + "\"" + this.format(mask, locale, value) + "\"" + suffix;
    }

    private String format(String mask, Locale locale, Date value) {
        DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern(mask).toFormatter(locale);
        return dtf.format(ZonedDateTime.ofInstant(value.toInstant(), ZoneId.of("UTC")));
    }

    private static <T extends Annotation> T getAnnotation(Class<?> clz, Class<T> annotation) {
        return DateFormatCustomizationTest.getAnnotationOnElement(clz, annotation);
    }

    private static <T extends Annotation> T getAnnotationOnMethod(Class<?> clz, Class<T> annotation, String methodName, Class<?> ... params) {
        try {
            Method m = clz.getDeclaredMethod(methodName, params);
            return DateFormatCustomizationTest.getAnnotationOnElement(m, annotation);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assertions.fail((String)e.getMessage());
            return null;
        }
    }

    private static <T extends Annotation> T getAnnotationOnField(Class<?> clz, Class<T> annotation, String fieldName) {
        try {
            Field f = clz.getDeclaredField(fieldName);
            return DateFormatCustomizationTest.getAnnotationOnElement(f, annotation);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Assertions.fail((String)e.getMessage());
            return null;
        }
    }

    private static <T extends Annotation> T getAnnotationOnPackage(Class<?> clz, Class<T> annotation) {
        Package p = clz.getPackage();
        return DateFormatCustomizationTest.getAnnotationOnElement(p, annotation);
    }

    private static <T extends Annotation> T getAnnotationOnElement(AnnotatedElement e, Class<T> annotation) {
        Annotation[] a = e.getAnnotationsByType(annotation);
        if (a == null || a.length == 0) {
            Assertions.fail((String)("No " + annotation.getName() + " annotation on " + e));
        }
        if (a.length != 1) {
            Assertions.fail((String)("Too many " + annotation.getName() + " annotation on " + e));
        }
        return (T)a[0];
    }

    private static String getDay(String yyyymmdd, Locale locale) {
        Calendar c = Calendar.getInstance(locale);
        c.set(1, Integer.parseInt(yyyymmdd.substring(0, 4)));
        c.set(2, Integer.parseInt(yyyymmdd.substring(4, 6)));
        c.set(5, Integer.parseInt(yyyymmdd.substring(6, 8)));
        SimpleDateFormat sdf = new SimpleDateFormat("EEE' 'dd' 'MMM", locale);
        return sdf.format(c.getTime());
    }
}

