/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonparsertests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonparsertests.Parser;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyBufferedInputStream;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    private boolean parseAndVerify_JsonObjectUTF(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"stringName", (String)"stringValue");
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"objectName");
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"foo", (String)"bar");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"arrayName");
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)1);
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)2);
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)3);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonObjectWithAllTypesOfData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"emptyString", (String)"");
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"emptyArray");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"emptyObject");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"string", (String)"string");
        JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"number", (int)100);
        JSONP_Util.testKeyTrueValue((JsonParser)parser, (String)"true");
        JSONP_Util.testKeyFalseValue((JsonParser)parser, (String)"false");
        JSONP_Util.testKeyNullValue((JsonParser)parser, (String)"null");
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"object");
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"emptyString", (String)"");
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"emptyArray");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"emptyObject");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"string", (String)"string");
        JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"number", (int)100);
        JSONP_Util.testKeyTrueValue((JsonParser)parser, (String)"true");
        JSONP_Util.testKeyFalseValue((JsonParser)parser, (String)"false");
        JSONP_Util.testKeyNullValue((JsonParser)parser, (String)"null");
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"object");
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"name", (String)"value");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"array");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"one");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"two");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"array");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"string");
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testTrueValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"name", (String)"value");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"one");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"two");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"intPositive", (int)100);
        JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"intNegative", (int)-100);
        JSONP_Util.testKeyLongValue((JsonParser)parser, (String)"longMax", (long)Long.MAX_VALUE);
        JSONP_Util.testKeyLongValue((JsonParser)parser, (String)"longMin", (long)Long.MIN_VALUE);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"fracPositive", (double)0.5);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"fracNegative", (double)-0.5);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expPositive1", (double)7000.0);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expPositive2", (double)7000.0);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expPositive3", (double)9000.0);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expPositive4", (double)9000.0);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expNegative1", (double)0.007);
        JSONP_Util.testKeyDoubleValue((JsonParser)parser, (String)"expNegative2", (double)0.007);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"asciiChars", (String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        for (i = 1; i < 31; ++i) {
            JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)("nested" + i));
            JSONP_Util.testKeyStringValue((JsonParser)parser, (String)("name" + i), (String)("value" + i));
        }
        for (i = 1; i < 31; ++i) {
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        }
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithLotsOfNestedObjectsData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"name1", (String)"value1");
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)("nested" + i));
            JSONP_Util.testKeyStringValue((JsonParser)parser, (String)("name" + i), (String)("value" + i));
        }
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        }
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithLotsOfNestedArraysData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"name1");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"value1");
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testStringValue((JsonParser)parser, (String)("nested" + i));
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
            JSONP_Util.testStringValue((JsonParser)parser, (String)("name" + i));
            JSONP_Util.testStringValue((JsonParser)parser, (String)("value" + i));
        }
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        }
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithMultipleArraysData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"string");
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testTrueValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"object", (String)"object");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"one");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"two");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)7.0E7);
        JSONP_Util.testTrueValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"object2", (String)"object2");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithAllTypesOfData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"string");
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testTrueValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"emptyString", (String)"");
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"emptyArray");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"emptyObject");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"string", (String)"string");
        JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"number", (int)100);
        JSONP_Util.testKeyTrueValue((JsonParser)parser, (String)"true");
        JSONP_Util.testKeyFalseValue((JsonParser)parser, (String)"false");
        JSONP_Util.testKeyNullValue((JsonParser)parser, (String)"null");
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"object");
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"name", (String)"value");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"array");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"one");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"two");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"string");
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testTrueValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"name", (String)"value");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"one");
        JSONP_Util.testStringValue((JsonParser)parser, (String)"two");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)100);
        JSONP_Util.testIntegerValue((JsonParser)parser, (int)-100);
        JSONP_Util.testLongValue((JsonParser)parser, (long)Long.MAX_VALUE);
        JSONP_Util.testLongValue((JsonParser)parser, (long)Long.MIN_VALUE);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)0.5);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)-0.5);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)7000.0);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)7000.0);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)9000.0);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)9000.0);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)0.007);
        JSONP_Util.testDoubleValue((JsonParser)parser, (double)0.007);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM");
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonHelloWorld(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStartObjectValue((JsonParser)parser, (String)"greetingObj");
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testKeyStringValue((JsonParser)parser, (String)"hello", (String)"world");
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testKeyStartArrayValue((JsonParser)parser, (String)"greetingArr");
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"hello");
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testStringValue((JsonParser)parser, (String)"world");
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_ARRAY);
        JSONP_Util.dumpLocation((JsonParser)parser);
        JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
        JSONP_Util.dumpLocation((JsonParser)parser);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            LOGGER.warning("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest1() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(Reader)]");
            LOGGER.info("-------------------------------------");
            LOGGER.info("Create Reader from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            StringReader reader = new StringReader("{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            LOGGER.info("Create JsonParser from the Reader");
            parser = Json.createParser((Reader)reader);
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithAllTypesOfData(parser), (String)"jsonParserTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest1 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest2() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonObject)]");
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("Create JsonObject from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString((String)"{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            JSONP_Util.dumpJsonObject((JsonObject)jsonObj);
            LOGGER.info("Create JsonParser from the JsonObject");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(jsonObj);
            LOGGER.info("parser=" + parser);
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithAllTypesOfData(parser), (String)"jsonParserTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest2 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest3() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(Reader) again]");
            LOGGER.info("-------------------------------------------");
            LOGGER.info("Create Reader from (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            StringReader reader = new StringReader("{\"nested1\" : {\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}");
            LOGGER.info("Create JsonParser from the Reader");
            parser = Json.createParser((Reader)reader);
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser), (String)"jsonParserTest3 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest3 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest4() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-----------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonObject object) again]");
            LOGGER.info("-----------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonObject from (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString((String)"{\"nested1\" : {\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}");
            JSONP_Util.dumpJsonObject((JsonObject)jsonObj);
            LOGGER.info("Create JsonParser from the JsonObject");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(jsonObj);
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser), (String)"jsonParserTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest4 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest5() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("---------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonArray)]");
            LOGGER.info("---------------------------------------------------------------------------");
            LOGGER.info("Create JsonArray from (JSONP_Data.jsonArrayWithMultipleArraysData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString((String)"[ \"string\", 100, true, false, null, { \"object\" : \"object\" }, [ \"one\",\"two\" ], [ 100, 7e7, true, false, null, { \"object2\" : \"object2\" } ] ]");
            JSONP_Util.dumpJsonArray((JsonArray)jsonArr);
            LOGGER.info("Create JsonParser from the JsonArray");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithMultipleArraysData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithMultipleArraysData(parser), (String)"jsonParserTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest5 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest6() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream)]");
            LOGGER.info("------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonArrayWithAllTypesOfData.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonArrayWithAllTypesOfData.json");
            LOGGER.info("Create JsonParser from the InputStream");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonArrayWithAllTypesOfData.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithAllTypesOfData(parser), (String)"jsonParserTest6 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest6 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest7() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(Reader)]");
            LOGGER.info("-------------------------------------------------------------------------");
            LOGGER.info("Create a Reader from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            StringReader reader = new StringReader("{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            LOGGER.info("Create JsonParser using Reader and a configuration");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser((Reader)reader);
            LOGGER.info("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithAllTypesOfData(parser), (String)"jsonParserTest7 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest7 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest8() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(JsonArray)]");
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("Create a JsonArray from (JSONP_Data.jsonArrayWithLotsOfNestedObjectsData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString((String)"[{\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}]");
            JSONP_Util.dumpJsonArray((JsonArray)jsonArr);
            LOGGER.info("Create JsonParser using JsonArray and a configuration");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            LOGGER.info("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithLotsOfNestedObjectsData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithLotsOfNestedObjectsData(parser), (String)"jsonParserTest8 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest8 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest9() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(JsonArray)]");
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("Create JsonArray from (JSONP_Data.jsonArrayWithMultipleArraysData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString((String)"[ \"string\", 100, true, false, null, { \"object\" : \"object\" }, [ \"one\",\"two\" ], [ 100, 7e7, true, false, null, { \"object2\" : \"object2\" } ] ]");
            JSONP_Util.dumpJsonArray((JsonArray)jsonArr);
            LOGGER.info("Create JsonParser using JsonArray and a configuration");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            LOGGER.info("Call JsonParser.toString() to print the JsonArray");
            parser.toString();
            LOGGER.info("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithMultipleArraysData)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithMultipleArraysData(parser), (String)"jsonParserTest9 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest9 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest10() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream)]");
            LOGGER.info("------------------------------------------------------------------------------");
            LOGGER.info("Create JsonParser using InputStream and a configuration");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectWithLotsOfNestedObjectsData.json");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream);
            LOGGER.info("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectWithLotsOfNestedObjectsData.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser), (String)"jsonParserTest10 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest10 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest11() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("--------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset)]");
            LOGGER.info("--------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonArrayWithAllTypesOfDataUTF16BE.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonArrayWithAllTypesOfDataUTF16BE.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-16BE");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16BE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonArrayWithAllTypesOfDataUTF16BE.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithAllTypesOfData(parser), (String)"jsonParserTest11 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest11 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest12() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("---------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream, Charset)]");
            LOGGER.info("---------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonArrayWithLotsOfNestedArraysData.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonArrayWithLotsOfNestedArraysData.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-8 and a configuration");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_8);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonArrayWithLotsOfNestedArraysData.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonArrayWithLotsOfNestedArraysData(parser), (String)"jsonParserTest12 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest12 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest13() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("---------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream, Charset)]");
            LOGGER.info("---------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectWithAllTypesOfDataUTF16LE.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectWithAllTypesOfDataUTF16LE.json");
            LOGGER.info("Create JsonParser from the InputStream using UTF-16LE encoding");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16LE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectWithAllTypesOfDataUTF16LE.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonObjectWithAllTypesOfData(parser), (String)"jsonParserTest13 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest13 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserTest14() {
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream)]");
            LOGGER.info("------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonHelloWorld.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource((String)"jsonHelloWorld.json");
            LOGGER.info("Create JsonParser from the InputStream");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonHelloWorld.json)");
            Assertions.assertTrue((boolean)this.parseAndVerify_JsonHelloWorld(parser), (String)"jsonParserTest14 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserTest14 Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void parseUTFEncodedTests() {
        InputStream istream;
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-8]");
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF8.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-8");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_8);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF8.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-8 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16]");
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-16");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-16 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16LE.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-16LE");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16LE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16BE.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-16BE");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16BE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-32LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32LE.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-32LE");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_32LE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("-------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-32BE]");
            LOGGER.info("-------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32BE.json");
            LOGGER.info("Create JsonParser from the InputStream with character encoding UTF-32BE");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_32BE);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"parseUTFEncodedTests Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void parseUTFEncodedTests2() {
        InputStream istream;
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            LOGGER.info("-------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-8]");
            LOGGER.info("-------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF8.json");
            LOGGER.info("Create JsonParser from the InputStream and auto-detect character encoding UTF-8");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF8.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-8 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-16LE]");
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16LE.json");
            LOGGER.info("Create JsonParser from the InputStream and auto-detect character encoding UTF-16LE");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-16BE]");
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16BE.json");
            LOGGER.info("Create JsonParser from the InputStream and auto-detect character encoding UTF-16BE");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-32LE]");
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32LE.json");
            LOGGER.info("Create JsonParser from the InputStream and auto-detect character encoding UTF-32LE");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-32BE]");
            LOGGER.info("----------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            istream = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32BE.json");
            LOGGER.info("Create JsonParser from the InputStream and auto-detect character encoding UTF-32BE");
            parser = Json.createParser((InputStream)istream);
            LOGGER.info("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing parsing of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"parseUTFEncodedTests2 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserIsIntegralNumberTest() {
        boolean pass = true;
        JsonParser parser = null;
        String jsonTestString = "[123, 12345.45]";
        try {
            LOGGER.info("Create JsonParser");
            parser = Json.createParser((Reader)new StringReader(jsonTestString));
            JsonParser.Event event = JSONP_Util.getNextSpecificParserEvent((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NUMBER);
            JSONP_Util.dumpEventType((JsonParser.Event)event);
            if (!JSONP_Util.assertEqualsJsonNumberType((boolean)parser.isIntegralNumber(), (boolean)true)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals((int)123, (int)parser.getInt())) {
                pass = false;
            }
            event = JSONP_Util.getNextSpecificParserEvent((JsonParser)parser, (JsonParser.Event)JsonParser.Event.VALUE_NUMBER);
            JSONP_Util.dumpEventType((JsonParser.Event)event);
            if (!JSONP_Util.assertEqualsJsonNumberType((boolean)parser.isIntegralNumber(), (boolean)false)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals((double)12345.45, (double)parser.getBigDecimal().doubleValue())) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserIsIntegralNumberTest Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserIsIntegralNumberTest Failed");
    }

    private boolean tripIllegalStateException(JsonParser parser, JsonParser.Event event) {
        boolean pass = true;
        if (event == null) {
            LOGGER.warning("event is null - unexpected.");
            return false;
        }
        LOGGER.info("Event=" + JSONP_Util.getEventTypeString((JsonParser.Event)event));
        LOGGER.info("Testing call to JsonParser.getString()");
        if (event != JsonParser.Event.VALUE_STRING && event != JsonParser.Event.VALUE_NUMBER && event != JsonParser.Event.KEY_NAME) {
            try {
                LOGGER.info("Trip IllegalStateException by calling JsonParser.getString()");
                String string = parser.getString();
                pass = false;
                LOGGER.warning("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                LOGGER.info("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                LOGGER.warning("Caught unexpected exception: " + e);
            }
        } else {
            LOGGER.info("No testing for IllegalStateException for this scenario.");
        }
        LOGGER.info("Testing call to JsonParser.isIntegralNumber()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                LOGGER.info("Trip IllegalStateException by calling JsonParser.isIntegralNumber()");
                boolean numberType = parser.isIntegralNumber();
                pass = false;
                LOGGER.warning("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                LOGGER.info("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                LOGGER.warning("Caught unexpected exception: " + e);
            }
        } else {
            LOGGER.info("No testing for IllegalStateException for this scenario.");
        }
        LOGGER.info("Testing call to JsonParser.getBigDecimal()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                LOGGER.info("Trip IllegalStateException by calling JsonParser.getBigDecimal()");
                BigDecimal number = parser.getBigDecimal();
                pass = false;
                LOGGER.warning("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                LOGGER.info("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                LOGGER.warning("Caught unexpected exception: " + e);
            }
        } else {
            LOGGER.info("No testing for IllegalStateException for this scenario.");
        }
        LOGGER.info("Testing call to JsonParser.getInt()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                LOGGER.info("Trip IllegalStateException by calling JsonParser.getInt()");
                int number = parser.getInt();
                pass = false;
                LOGGER.warning("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                LOGGER.info("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                LOGGER.warning("Caught unexpected exception: " + e);
            }
        } else {
            LOGGER.info("No testing for IllegalStateException for this scenario.");
        }
        LOGGER.info("Testing call to JsonParser.getLong()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                LOGGER.info("Trip IllegalStateException by calling JsonParser.getLong()");
                long number = parser.getLong();
                pass = false;
                LOGGER.warning("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                LOGGER.info("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                LOGGER.warning("Caught unexpected exception: " + e);
            }
        } else {
            LOGGER.info("No testing for IllegalStateException for this scenario.");
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonParserIllegalExceptionTests() {
        boolean pass = true;
        JsonParser parser = null;
        String jsonTestString = "[\"string\",100,false,null,true,{\"foo\":\"bar\"}]";
        try {
            LOGGER.info("Create JsonParser");
            parser = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig()).createParser((Reader)new StringReader(jsonTestString));
            JsonParser.Event event = JSONP_Util.getNextParserEvent((JsonParser)parser);
            if (!this.tripIllegalStateException(parser, event)) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent((JsonParser)parser))) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParserIllegalExceptionTests Failed: ", (Throwable)e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserIllegalExceptionTests Failed");
    }

    @Test
    public void jsonParserIOErrorTests() {
        JsonParser parser;
        MyBufferedInputStream mbi;
        InputStream is;
        boolean pass = true;
        String jsonText = "{\"name1\":\"value1\",\"name2\":\"value2\"}";
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on Json.createParser(InputStream).");
            LOGGER.info("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString((String)jsonText);
            mbi = new MyBufferedInputStream(is, true);
            LOGGER.info("Calling Json.createParser(InputStream)");
            parser = Json.createParser((InputStream)mbi);
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on JsonParser.next().");
            LOGGER.info("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString((String)jsonText);
            mbi = new MyBufferedInputStream(is, true);
            parser = Json.createParser((InputStream)mbi);
            LOGGER.info("Calling JsonParser.next()");
            parser.next();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on JsonParser.close().");
            LOGGER.info("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString((String)jsonText);
            mbi = new MyBufferedInputStream(is);
            parser = Json.createParser((InputStream)mbi);
            mbi.setThrowIOException(true);
            LOGGER.info("Calling JsonParser.close()");
            parser.close();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserIOErrorTests Failed");
    }

    @Test
    public void jsonParserExceptionTests() {
        JsonParser parser;
        InputStream is;
        boolean pass = true;
        try {
            LOGGER.info("Trip JsonParsingException for JsonParser.next() if incorrect JSON is encountered");
            is = JSONP_Util.getInputStreamFromString((String)"}{");
            parser = Json.createParser((InputStream)is);
            parser.next();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NoSuchElementException for JsonParser.next() if no more parsing states");
            is = JSONP_Util.getInputStreamFromString((String)"{}");
            parser = Json.createParser((InputStream)is);
            parser.next();
            parser.next();
            parser.next();
            LOGGER.warning("Did not get expected NoSuchElementException");
            pass = false;
        }
        catch (NoSuchElementException e) {
            LOGGER.info("Caught expected NoSuchElementException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParserExceptionTests Failed");
    }

    @Test
    public void invalidLiteralNamesTest() {
        JsonParser parser;
        boolean pass = true;
        try {
            LOGGER.info("Trip JsonParsingException for JsonParser.next() if invalid liternal TRUE instead of true.");
            LOGGER.info("Reading [TRUE]");
            parser = Json.createParser((Reader)new StringReader("[TRUE]"));
            parser.next();
            parser.next();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonParser.next() if invalid liternal FALSE instead of false.");
            LOGGER.info("Reading [FALSE]");
            parser = Json.createParser((Reader)new StringReader("[FALSE]"));
            parser.next();
            parser.next();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonParser.next() if invalid liternal NULL instead of null.");
            LOGGER.info("Reading [NULL]");
            parser = Json.createParser((Reader)new StringReader("[NULL]"));
            parser.next();
            parser.next();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"invalidLiteralNamesTest Failed");
    }

    @Test
    public void jsonParser11Test() {
        Parser parserTest = new Parser();
        TestResult result = parserTest.test();
        result.eval();
    }

    @Test
    public void jsonParserCurrentEvent() {
        try (JsonParser parser = Json.createParser((Reader)new StringReader("{\"a\":\"v\",\"b\":\"w\"}"));){
            Assertions.assertNull((Object)parser.currentEvent());
            int events = 0;
            while (parser.hasNext()) {
                JsonParser.Event next = parser.next();
                Assertions.assertNotNull((Object)next);
                Assertions.assertEquals((Object)next, (Object)parser.currentEvent());
                Assertions.assertEquals((Object)parser.currentEvent(), (Object)parser.currentEvent());
                ++events;
            }
            Assertions.assertEquals((int)6, (int)events);
        }
    }
}

