/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

public class Preferences {
    private static Preferences theOne;
    private static I18NResourceBundle i18n;
    private File prefsFile;
    private Map<String, String> props;
    private Map<String, Observer[]> observers = new Hashtable<String, Observer[]>();
    private boolean isUpToDate;
    private long fileModifiedTime;

    private Preferences(File file) {
        this.prefsFile = file;
        this.isUpToDate = true;
        this.props = new TreeMap<String, String>();
        try {
            if (this.prefsFile != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.prefsFile));
                this.props = PropertyUtils.loadSorted(in);
                ((InputStream)in).close();
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Preferences access() {
        if (theOne == null) {
            theOne = new Preferences(Preferences.getDefaultPrefsFile());
        }
        return theOne;
    }

    public static File getPrefsDir() {
        File userDir = new File(System.getProperty("user.home"));
        String prefDir = System.getProperty("javatest.preferences.dir", ".javatest");
        return new File(userDir, prefDir);
    }

    private static File getDefaultPrefsFile() {
        String s = System.getProperty("javatest.preferences.file");
        if (s == null) {
            File jtDir = Preferences.getPrefsDir();
            return new File(jtDir, "preferences");
        }
        if (!s.equals("NONE")) {
            return new File(s);
        }
        return null;
    }

    public synchronized void save() {
        if (!(this.prefsFile == null || this.isUpToDate && this.fileModifiedTime == this.prefsFile.lastModified())) {
            try {
                File parentDir = new File(this.prefsFile.getParent());
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.prefsFile));
                PropertyUtils.store(this.props, out, "JT Harness Preferences");
                ((OutputStream)out).close();
                this.isUpToDate = true;
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
            catch (IOException e) {
                System.err.println(i18n.getString("prefs.cannotSave", (Object)e));
            }
        }
    }

    public String getPreference(String name) {
        return this.getPreference(name, null);
    }

    public String getPreference(String name, String defaultValue) {
        String v = this.props.get(name);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    public void setPreference(String name, String newValue) {
        this.isUpToDate = false;
        this.props.put(name, newValue);
        for (String prefix : this.observers.keySet()) {
            Observer[] obs;
            if (!name.startsWith(prefix)) continue;
            for (Observer ob : obs = this.observers.get(prefix)) {
                ob.updated(name, newValue);
            }
        }
    }

    public void addObserver(String prefix, Observer o) {
        Observer[] obs = this.observers.get(prefix);
        obs = obs == null ? new Observer[]{o} : DynamicArray.append(obs, o);
        this.observers.put(prefix, obs);
    }

    public void addObserver(String[] prefixes, Observer o) {
        for (String prefixe : prefixes) {
            this.addObserver(prefixe, o);
        }
    }

    public void removeObserver(String prefix, Observer o) {
        Observer[] obs = this.observers.get(prefix);
        if (obs != null) {
            obs = DynamicArray.remove(obs, o);
            this.observers.put(prefix, obs);
        }
    }

    public void removeObserver(String[] prefixes, Observer o) {
        for (String prefixe : prefixes) {
            this.removeObserver(prefixe, o);
        }
    }

    Map<String, String> getProperties() {
        return this.props;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Preferences.class);
    }

    public static interface Observer {
        public void updated(String var1, String var2);
    }
}

