/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.WorkDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class LastRunInfo {
    private static final String FILENAME = "lastRun.txt";
    private static final String START = "startTime";
    private static final String FINISH = "finishTime";
    private static final String CONFIG = "configName";
    private static final String TEST_URLS = "testURLs";
    private static final String SEP = " ";
    private String configName;
    private long startTime;
    private long finishTime;
    private List<String> testURLs;

    private LastRunInfo() {
    }

    private LastRunInfo(WorkDirectory wd) throws IOException {
        this();
        Properties p;
        try (FileInputStream in = new FileInputStream(wd.getSystemFile(FILENAME));){
            p = new Properties();
            p.load(in);
        }
        String val = p.getProperty(START);
        try {
            this.startTime = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        val = p.getProperty(FINISH);
        try {
            this.finishTime = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.configName = p.getProperty(CONFIG);
        this.testURLs = LastRunInfo.split(p.getProperty(TEST_URLS));
    }

    private static String join(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append(SEP);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static List<String> split(String joined) {
        ArrayList<String> list = new ArrayList<String>();
        if (joined == null || joined.trim().isEmpty()) {
            return list;
        }
        int begin = 0;
        int end = joined.indexOf(SEP);
        while (end >= 0) {
            list.add(joined.substring(begin, end));
            begin = end + SEP.length();
            end = joined.indexOf(SEP, begin);
        }
        list.add(joined.substring(begin));
        return list;
    }

    public static LastRunInfo readInfo(WorkDirectory wd) throws IOException {
        return new LastRunInfo(wd);
    }

    public static void writeInfo(WorkDirectory workdir, long start, long stop, String config, List<String> testURLs) throws IOException {
        Properties p = new Properties();
        p.setProperty(CONFIG, config);
        p.setProperty(START, Long.toString(start));
        p.setProperty(FINISH, Long.toString(stop));
        p.setProperty(TEST_URLS, LastRunInfo.join(testURLs));
        try (FileOutputStream out = new FileOutputStream(workdir.getSystemFile(FILENAME));){
            p.store(out, "Last test run info");
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Date getStartDate() {
        return new Date(this.startTime);
    }

    public Date getFinishDate() {
        return new Date(this.finishTime);
    }

    public String getConfigName() {
        return this.configName;
    }

    public List<String> getTestURLs() {
        return this.testURLs;
    }
}

