/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.TestSuite;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;

public class KnownFailuresListInterview
extends Interview {
    private InterviewParameters parent;
    private boolean initializedForTestSuite;
    private NeedKflQuestion qNeedKfl;
    private KnownFailuresList cachedKfl;
    private Question cachedKflError;
    private Object[] cachedExcludeListErrorArgs;
    private TestSuite cachedExcludeList_testSuite;
    private File[] cachedExcludeList_files;
    private ErrorQuestion qKflFileNotFound = new ErrorQuestion(this, "KflFileNotFound"){

        @Override
        protected Object[] getTextArgs() {
            return KnownFailuresListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qKflIOError = new ErrorQuestion(this, "KflIOError"){

        @Override
        protected Object[] getTextArgs() {
            return KnownFailuresListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qKflError = new ErrorQuestion(this, "KflError"){

        @Override
        protected Object[] getTextArgs() {
            return KnownFailuresListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private FileListQuestion qCustomFiles = new FileListQuestion(this, "customFiles"){
        {
            KnownFailuresListInterview.this.setResourceBundle("i18n");
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(".jtx", this.getResourceString("KnownFailuresListInterview.jtx.extn.desc", false)), new ExtensionFileFilter(".txt", this.getResourceString("KnownFailuresListInterview.txt.extn.desc", false)), new ExtensionFileFilter(".kfl", this.getResourceString("KnownFailuresListInterview.kfl.extn.desc", false))};
            this.setFilters(filters);
            this.setDuplicatesAllowed(false);
        }

        @Override
        protected Question getNext() {
            if (this.value == null || this.value.length == 0) {
                return null;
            }
            return KnownFailuresListInterview.this.checkExcludeList();
        }

        @Override
        public File getBaseDirectory() {
            TestSuite ts = KnownFailuresListInterview.this.parent.getTestSuite();
            return ts == null ? null : ts.getRootDir();
        }
    };

    public KnownFailuresListInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "knownFailuresList");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.qNeedKfl = new NeedKflQuestion();
        this.setFirstQuestion(this.qNeedKfl);
    }

    private static File[] getAbsoluteFiles(File baseDir, File ... files) {
        if (files == null) {
            return null;
        }
        if (baseDir == null) {
            return files;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    private static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    private static boolean equal(File[] f1, File ... f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.cachedKfl = null;
        this.cachedKflError = null;
        this.cachedExcludeListErrorArgs = null;
        this.cachedExcludeList_testSuite = null;
        this.cachedExcludeList_files = null;
    }

    public File[] getKflFiles() {
        return this.qNeedKfl.getValue().equals("No") ? null : this.qCustomFiles.getValue();
    }

    public void setKflFiles(File ... files) {
        if (files == null || files.length == 0) {
            this.qNeedKfl.setValue("No");
            this.setCustomKflFiles(null);
        } else {
            this.qNeedKfl.setValue("Yes");
            this.setCustomKflFiles(files);
        }
        this.updatePath(this.qNeedKfl);
        this.setEdited(true);
        this.updateCachedExcludeListData();
    }

    protected void setCustomKflFiles(File ... files) {
        this.qCustomFiles.setValue(files);
        this.updatePath(this.qCustomFiles);
    }

    public KnownFailuresList getKfl() {
        this.updateCachedExcludeListData();
        return this.cachedKfl;
    }

    public boolean isKflEnabled() {
        return this.qNeedKfl.getValue().equals("Yes");
    }

    private void updateCachedExcludeListData() {
        TestSuite ts = this.parent.getTestSuite();
        File tsRootDir = ts == null ? null : ts.getRootDir();
        File[] files = KnownFailuresListInterview.getAbsoluteFiles(tsRootDir, this.getKflFiles());
        if (!KnownFailuresListInterview.equal(this.cachedExcludeList_files, files) || this.cachedExcludeList_testSuite != ts) {
            try {
                if (ts == null || files == null || files.length == 0) {
                    this.setCachedKfl(new KnownFailuresList());
                } else {
                    this.setCachedKfl(new KnownFailuresList(files));
                }
            }
            catch (FileNotFoundException e) {
                this.setCachedKflError(this.qKflFileNotFound, e.getMessage());
            }
            catch (IOException e) {
                this.setCachedKflError(this.qKflIOError, e.toString());
            }
            catch (KnownFailuresList.Fault e) {
                this.setCachedKflError(this.qKflError, e.getMessage());
            }
            this.cachedExcludeList_files = files;
            this.cachedExcludeList_testSuite = ts;
        }
    }

    private void setCachedKfl(KnownFailuresList l) {
        this.cachedKfl = l;
        this.cachedKflError = null;
        this.cachedExcludeListErrorArgs = null;
    }

    private void setCachedKflError(Question q, String arg) {
        this.cachedKfl = new KnownFailuresList();
        this.cachedKflError = q;
        this.cachedExcludeListErrorArgs = new String[]{arg};
    }

    private Question checkExcludeList() {
        this.updateCachedExcludeListData();
        if (this.cachedKflError != null) {
            return this.cachedKflError;
        }
        return this.qEnd;
    }

    private class NeedKflQuestion
    extends YesNoQuestion {
        private boolean doneSuper;

        NeedKflQuestion() {
            super(KnownFailuresListInterview.this, "needKfl");
            this.setDefaultValue("No");
            this.setValue("No");
            this.clear();
            this.doneSuper = true;
        }

        @Override
        public void clear() {
            if (!this.doneSuper) {
                return;
            }
            super.clear();
        }

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (Objects.equals(this.value, "Yes")) {
                return KnownFailuresListInterview.this.qCustomFiles;
            }
            return KnownFailuresListInterview.this.qEnd;
        }
    }
}

